import random

import numpy as np
import pandas as pd
from netZooPy.ligress.bonobo import Bonobo
from bonobo_competitors_scaled import lioness
from bonobo_competitors_scaled import spcc
from bonobo_competitors_scaled import sweet
from bonobo_simulation_module_mixture_scaledCompetitors import simulate_bonobo_mixture

random.seed(10)

### Compute MSE for Nsim-many Simulated Data
mix_prop = 0.2
ngene = 500
sim_mean1 = pd.read_csv("/home/esaha/BONOBO/data/simulation_simple/simulation_mean500.csv")
sim_cov1 = pd.read_csv("/home/esaha/BONOBO/data/simulation_simple/simulation_covariance500.csv", sep = " ")
sim_mean2 = sim_mean1*0.8
sim_cov2 = sim_cov1 + 4*np.identity(ngene)

Nsim = 100
nsample = 100
mse_bonobo = []
mse_bonobo_sparse = []
mse_lioness = []
mse_spcc = []
mse_sweet = []
for i in range(Nsim):
  mse_b, mse_bs, mse_l, mse_s, mse_sw = simulate_bonobo_mixture(sim_mean1, sim_cov1, sim_mean2, sim_cov2, mix_prop, nsample = 100, nsample_ind = 100, ngene = ngene)
  mse_b = sum(mse_b)/len(mse_b)
  mse_bs = sum(mse_bs)/len(mse_bs)
  mse_l = sum(mse_l)/len(mse_l)
  mse_s = sum(mse_s)/len(mse_s)
  mse_sw = sum(mse_sw)/len(mse_sw)
  mse_bonobo.append(mse_b)
  mse_bonobo_sparse.append(mse_bs)
  mse_lioness.append(mse_l)
  mse_spcc.append(mse_s)
  mse_sweet.append(mse_sw)


# Combine the lists using pandas
results = pd.DataFrame({
  "mse_bonobo": mse_bonobo,
  "mse_bonobo_sparse": mse_bonobo_sparse,
  "mse_lioness": mse_lioness,
  "mse_spcc": mse_spcc,
  "mse_sweet": mse_sweet
})

# Save the combined DataFrame to a text file
results.to_csv("bonobo_simulation_results_mixture_prop_varyGene" + str(mix_prop) + ".txt", sep="\t", index=False)

results.mean(axis=0)



