import random

import numpy as np
import pandas as pd
from netZooPy.ligress.bonobo import Bonobo
from bonobo_simulation_module_mixture_varyDelta import simulate_bonobo_mixture_varyDelta

random.seed(10)

### Compute MSE for Nsim-many Simulated Data
delta = 0.1
mix_prop = 0.2
sim_mean1 = pd.read_csv("/home/esaha/BONOBO/data/simulation_simple/simulation_mean100.csv")
sim_cov1 = pd.read_csv("/home/esaha/BONOBO/data/simulation_simple/simulation_covariance100.csv", sep = " ")
sim_mean2 = sim_mean1*0.8
sim_cov2 = sim_cov1 + 4*np.identity(100)

Nsim = 100
nsample = 100
mse_bonobo = []
mse_bonobo_sparse = []
mse_lioness = []
mse_spcc = []
for i in range(Nsim):
  mse_b, mse_bs = simulate_bonobo_mixture_varyDelta(sim_mean1, sim_cov1, sim_mean2, sim_cov2, mix_prop = mix_prop, delta = delta, nsample = 100, nsample_ind = 100)
  mse_b = sum(mse_b)/len(mse_b)
  mse_bs = sum(mse_bs)/len(mse_bs)
  mse_bonobo.append(mse_b)
  mse_bonobo_sparse.append(mse_bs)
  

# Combine the lists using pandas
results = pd.DataFrame({
    "mse_bonobo": mse_bonobo,
    "mse_bonobo_sparse": mse_bonobo_sparse
})

# Save the combined DataFrame to a text file
results.to_csv("bonobo_simulation_results_mixture_delta" + str(delta) + ".txt", sep="\t", index=False)

results.mean(axis=0)


