##### Vectorize lioness matrices of individual samples and combine into a single matrix ######
##### Read lioness networks: Female (GTEx)
rm(list=ls())

# Number of mRNA
n_mRNA = 19504

library(data.table)
setwd(paste("/home/ubuntu/bonobo"))
files_ls = list.files(path=".", pattern=".txt", all.files=TRUE,
                      full.names=TRUE)

indices = gsub(".txt", "", gsub("./bonobo_*", "", files_ls))

data_all = list()
data_mRNA = list()
data_miRNA = list()
i=0
for (file_name in files_ls){
  i = i+1
  new_data = fread(file_name)
  data_all[[i]] = colSums(new_data)
  data_mRNA[[i]] = colSums(new_data[1:n_mRNA,])
  data_miRNA[[i]] = colSums(new_data[-(1:n_mRNA),])
  cat(paste(i,"\n"))
}

indegree_all = do.call(cbind, data_all)
indegree_mRNA = do.call(cbind, data_mRNA)
indegree_miRNA = do.call(cbind, data_miRNA)

rownames(indegree_all) = names(data_all[[i]])
colnames(indegree_all) = indices
head(indegree_all[,1:4])

rownames(indegree_mRNA) = names(data_mRNA[[i]])
colnames(indegree_mRNA) = indices
head(indegree_mRNA[,1:4])

rownames(indegree_miRNA) = names(data_miRNA[[i]])
colnames(indegree_miRNA) = indices
head(indegree_miRNA[,1:4])

write.table(indegree_all, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/indegree_all.txt", row.names=T, col.names=T)
write.table(indegree_mRNA, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/indegree_mRNA.txt", row.names=T, col.names=T)
write.table(indegree_miRNA, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/indegree_miRNA.txt", row.names=T, col.names=T)

################################################

# Positive-negative correlation added separately to compute positive indegree and negative indegree

##### Vectorize lioness matrices of individual samples and combine into a single matrix ######
##### Read lioness networks: Female (GTEx)
rm(list=ls())

# Number of mRNA
n_mRNA = 19504

library(data.table)
setwd(paste("/home/ubuntu/bonobo"))
files_ls = list.files(path=".", pattern=".txt", all.files=TRUE,
                      full.names=TRUE)

indices = gsub(".txt", "", gsub("./bonobo_*", "", files_ls))

# Read TF_gene names from PANDA networks
data_all = list()
data_pos = list()
data_neg = list()
i=0
for (file_name in files_ls){
  i = i+1
  new_data = fread(file_name)[-(1:n_mRNA),]
  data_all[[i]] = colSums(new_data)
  data_pos[[i]] = apply(new_data, MARGIN = 2, function(x){sum(x[which(x>0)])})
  data_neg[[i]] = apply(new_data, MARGIN = 2, function(x){sum(x[which(x<=0)])})
  cat(paste(i,"\n"))
}

indegree = do.call(cbind, data_all)
indegree_pos = do.call(cbind, data_pos)
indegree_neg = do.call(cbind, data_neg)

rownames(indegree) = names(data_all[[i]])
colnames(indegree) = indices
head(indegree[,1:4])

rownames(indegree_pos) = names(data_pos[[i]])
colnames(indegree_pos) = indices
head(indegree_pos[,1:4])

rownames(indegree_neg) = names(data_neg[[i]])
colnames(indegree_neg) = indices
head(indegree_neg[,1:4])

write.table(indegree, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/miRNA_indegree.txt", row.names=T, col.names=T)
write.table(indegree_pos, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/miRNA_indegree_positive.txt", row.names=T, col.names=T)
write.table(indegree_neg, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/miRNA_indegree_negative.txt", row.names=T, col.names=T)



