##### Vectorize lioness matrices of individual samples and combine into a single matrix ######

rm(list=ls())
set.seed(1)

# Package to vectorize matrix
library(gdata)

# Number of mRNA
n_mRNA = 19504

library(data.table)
setwd(paste("/home/ubuntu/bonobo"))
files_ls = list.files(path=".", pattern=".txt", all.files=TRUE,
                      full.names=TRUE)

indices = gsub(".txt", "", gsub("./bonobo_*", "", files_ls))

# Get phenotypic data
phenotype = read.csv("~/BONOBO/data/miRNA_mRNA_breastCancer/GSE19783_phenotype.txt", sep="")

subtypes = phenotype$breast.cancer.subtype.ch1[match(indices, rownames(phenotype))]

indices = indices[which(subtypes %in% c("Lum A", "Lum B"))]
files_ls = files_ls[which(subtypes %in% c("Lum A", "Lum B"))]

immuneGenes = read.table("~/BONOBO/plots/GSE19783_miRNA_immuneGenes_lumAlumB_GSEAleadingEdge.txt", quote="\"", comment.char="")$V1

data_lumAB = list()
i=0
for (file_name in files_ls){
  i = i+1
  new_data = data.frame(fread(file_name))
  m = new_data[-(1:n_mRNA),immuneGenes]
  rownames(m) = colnames(new_data)[-(1:n_mRNA)]
  m = as.matrix(m)
  data_lumAB[[i]] = unmatrix(m)
  cat(paste(i,"\n"))
}

edges = do.call(cbind, data_lumAB)
colnames(edges) = indices
head(edges[,1:4])

write.table(edges, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/lumAB_edges_immueGenes.txt", row.names=T, col.names=T)

####################################
##### Vectorize lioness matrices of individual samples and combine into a single matrix ######

rm(list=ls())
set.seed(1)

# Package to vectorize matrix
library(gdata)

# Number of mRNA
n_mRNA = 19504

library(data.table)
setwd(paste("/home/ubuntu/bonobo"))
files_ls = list.files(path=".", pattern=".txt", all.files=TRUE,
                      full.names=TRUE)

indices = gsub(".txt", "", gsub("./bonobo_*", "", files_ls))

data_all = list()
i=0
for (file_name in files_ls){
  i = i+1
  new_data = data.frame(fread(file_name))
  m = new_data[-(1:n_mRNA),]
  rownames(m) = colnames(new_data)[-(1:n_mRNA)]
  m = as.matrix(m)
  data_all[[i]] = unmatrix(m)
  cat(paste(i,"\n"))
}

edges = do.call(cbind, data_all)
colnames(edges) = indices
head(edges[,1:4])

write.table(edges, file="/home/esaha/BONOBO/network/miRNA_mRNA_breastCancer/GSE19783_miRNAmRNA_edges.txt", row.names=T, col.names=T)

