library(ggplot2)
library(ggrepel)

# add a column of NAs
tb$direction <- "Not significant"
# if log2Foldchange > 25 and -log10(pvalue) > 5, set as "UP" 
tb$direction[tb$logFC > 25 & tb$P.Value < 0.05] <- "FEMALE"
# if log2Foldchange < -0.6 and pvalue < 0.05, set as "DOWN"
tb$direction[tb$logFC < -25 & tb$P.Value < 0.05] <- "MALE"

mycolors <- c("blue", "red", "grey")
names(mycolors) <- c("MALE", "FEMALE", "Not significant")

# Create a new column "delabel" to de, that will contain the name of genes differentially expressed (NA in case they are not)
tb$delabel <- NA
tb$delabel[tb$direction != "Not significant"] <- tb$gene_name[tb$direction != "Not significant"]

# Re-plot but this time color the points with "diffexpressed"
ggplot(data=tb, aes(x=logFC, y=-log10(P.Value), col=direction, label = delabel)) +
  geom_point() + theme_minimal() +
  geom_vline(xintercept=c(-25, 25), col="red") +
  geom_hline(yintercept=-log10(0.05), col="red") +
  scale_colour_manual(values = mycolors) +
  ggtitle("Volcanoplot of Differentially Targeted Genes") +
  geom_text_repel(size = 3)

