# Prepare motif file
library(data.table)
expression = fread("/home/esaha/BONOBO/data/GTEx_thyroid/GTEx_thyroid_allSex.txt")
sample = colnames(expression)[-1]

# Separate Male and Female Expression
load("~/BONOBO/data/GTEx_thyroid/GTEx_thyroid_RSE.RData")
male = rownames(GTEx_thyroid@colData)[which(GTEx_thyroid@colData$gtex.sex == "1")]
female = rownames(GTEx_thyroid@colData)[which(GTEx_thyroid@colData$gtex.sex == "2")]

male_sample = which(sample %in% male)
female_sample = which(sample %in% female)

female_prior = "/home/ubuntu/prior_large/prior_female.txt"
male_prior = "/home/ubuntu/prior_large/prior_male.txt"
prior = rep(0, length(sample))
prior[male_sample] = male_prior
prior[female_sample] = female_prior
prior_tab = data.frame(cbind(sample, prior))

head(prior_tab)

write.table(prior_tab, paste("/home/esaha/BONOBO/data/GTEx_thyroid/GTEx_thyroid_motif.csv", sep = ""), row.names = FALSE, col.names = TRUE, sep = ",", quote = F)

