require(ggplot2)
require(readr)
require(cowplot)
require(dplyr)


runtimes <- read_csv("~/Downloads/runtimes.csv")

ggplot(runtimes %>% filter(challenge == "cami2") %>% filter(detail != "(gsa)" | is.na(detail))  %>% filter(dataset == "strain madness") %>% filter(task %in% c("taxonomic profiling", "taxonomic binning"))) + 
  aes(color = Name,  x= jitter(`Runtime (hours)`, factor = 1.35), y = `Maximum memory (GB)`) + geom_point(size= 5, alpha=0.8) +
  scale_y_continuous(trans = "log10") + scale_x_continuous(trans = "log10") + theme_cowplot() + 
  scale_color_manual(values=c("#E31A1C", "darkred", "darkgray", "darkorange", "#B2DF8A", "#FB9A99", "#FDBF6F", "navy", "#2AADDC", "purple",  "#B15928")) +
  labs(title = "CAMI-II strain-madness dataset", x = "Runtime (hours)", color = "")
