/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.survival.nonparametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CoxMantel {
    public static double getPvalue(TransposeDataCollection transposeDataCollection) {
        if (transposeDataCollection.size() != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object[] keys = transposeDataCollection.keySet().toArray();
        HashMap<Object, Integer> r = new HashMap<Object, Integer>();
        r.put(keys[0], 0);
        r.put(keys[1], 0);
        ArrayList mergedUncensoredData = new ArrayList();
        for (Object entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = (FlatDataCollection)entry.getValue();
            for (Object value : flatDataCollection) {
                if (value.toString().endsWith("+")) continue;
                mergedUncensoredData.add(value);
                r.put(j, (Integer)r.get(j) + 1);
            }
        }
        Collections.sort(mergedUncensoredData, (o1, o2) -> {
            double v2;
            double v1 = TypeInference.toDouble((Object)o1);
            if (v1 > (v2 = TypeInference.toDouble((Object)o2).doubleValue())) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        });
        AssociativeArray2D testTable = new AssociativeArray2D();
        for (Object ti : mergedUncensoredData) {
            Double tiValue = TypeInference.toDouble(ti);
            Object value = testTable.get2d(ti, (Object)"mi");
            if (value != null) {
                testTable.put2d(ti, (Object)"mi", (Object)((Integer)value + 1));
                continue;
            }
            testTable.put2d(ti, (Object)"mi", (Object)1);
            testTable.put2d(ti, (Object)"r0ti", (Object)0);
            testTable.put2d(ti, (Object)"r1ti", (Object)0);
            for (Map.Entry entry : transposeDataCollection.entrySet()) {
                Object j = entry.getKey();
                FlatDataCollection flatDataCollection = (FlatDataCollection)entry.getValue();
                int jIndex = j.equals(keys[1]) ? 1 : 0;
                String rJtiKey = "r" + String.valueOf(jIndex) + "ti";
                for (Object value2 : flatDataCollection) {
                    String str = value2.toString();
                    double v = str.endsWith("+") ? Double.valueOf(str.substring(0, str.length() - "+".length())).doubleValue() : TypeInference.toDouble(value2).doubleValue();
                    if (!(v >= tiValue)) continue;
                    testTable.put2d(ti, (Object)rJtiKey, (Object)((Integer)testTable.get2d(ti, (Object)rJtiKey) + 1));
                }
            }
        }
        double U = ((Integer)r.get(keys[1])).intValue();
        double VarU = 0.0;
        for (Map.Entry entry : testTable.entrySet()) {
            AssociativeArray testRow = (AssociativeArray)entry.getValue();
            double r0ti = testRow.getDouble((Object)"r0ti");
            double r1ti = testRow.getDouble((Object)"r1ti");
            double mi = testRow.getDouble((Object)"mi");
            double rti = r0ti + r1ti;
            double Ai = r1ti / rti;
            U -= mi * Ai;
            VarU += mi * (rti - mi) / (rti - 1.0) * Ai * (1.0 - Ai);
        }
        double Z = U / Math.sqrt(VarU);
        double pvalue = CoxMantel.scoreToPvalue(Z);
        return pvalue;
    }

    public static boolean test(TransposeDataCollection transposeDataCollection, boolean is_twoTailed, double aLevel) {
        double pvalue = CoxMantel.getPvalue(transposeDataCollection);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score) {
        return ContinuousDistributions.gaussCdf(score);
    }
}

