/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.relatedsamples;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class PearsonCorrelation {
    public static double calculateCorrelation(TransposeDataList transposeDataList) {
        Object[] keys = transposeDataList.keySet().toArray();
        if (keys.length != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object keyX = keys[0];
        Object keyY = keys[1];
        FlatDataCollection flatDataCollectionX = transposeDataList.get(keyX).toFlatDataCollection();
        FlatDataCollection flatDataCollectionY = transposeDataList.get(keyY).toFlatDataCollection();
        int n = flatDataCollectionX.size();
        if (n <= 2 || n != flatDataCollectionY.size()) {
            throw new IllegalArgumentException("The number of observations in each group must be equal and larger than 2.");
        }
        double stdX = Descriptives.std(flatDataCollectionX, true);
        double stdY = Descriptives.std(flatDataCollectionY, true);
        double covariance = Descriptives.covariance(transposeDataList, true);
        double pearson = covariance / (stdX * stdY);
        return pearson;
    }

    public static boolean test(TransposeDataList transposeDataList, boolean is_twoTailed, double aLevel) {
        double pearson = PearsonCorrelation.calculateCorrelation(transposeDataList);
        Object[] keys = transposeDataList.keySet().toArray();
        int n = transposeDataList.get(keys[0]).size();
        double pvalue = PearsonCorrelation.scoreToPvalue(pearson, n);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n) {
        double T = score / Math.sqrt((1.0 - score * score) / (double)(n - 2));
        return ContinuousDistributions.studentsCdf(T, n - 2);
    }
}

