/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.onesample;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.Iterator;

public class LjungBox {
    public static boolean testAutocorrelation(FlatDataCollection pkList, int n, double aLevel) {
        int h = pkList.size();
        if (n <= h) {
            throw new IllegalArgumentException("The n must be larger than the size of pkList.");
        }
        double Q = 0.0;
        int k = 1;
        Iterator it = pkList.iteratorDouble();
        while (it.hasNext()) {
            Double pkValue = (Double)it.next();
            Q += pkValue * pkValue / (double)(n - k);
            ++k;
        }
        boolean rejectH0 = LjungBox.checkCriticalValue(Q *= (double)(n * (n + 2)), h, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int h, double aLevel) {
        return LjungBox.checkCriticalValue(score, h, aLevel, 0, 0);
    }

    private static boolean checkCriticalValue(double score, int h, double aLevel, int p, int q) {
        double probability = ContinuousDistributions.chisquareCdf(score, h - p - q);
        boolean rejectH0 = false;
        double a = aLevel;
        if (probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

