/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.relatedsamples;

import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class SignRelatedSamples {
    public static double getPvalue(TransposeDataList transposeDataList) {
        Object[] keys = transposeDataList.keySet().toArray();
        if (keys.length != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object keyX = keys[0];
        Object keyY = keys[1];
        FlatDataList flatDataListX = transposeDataList.get(keyX);
        FlatDataList flatDataListY = transposeDataList.get(keyY);
        int n = flatDataListX.size();
        if (n <= 0 || n != flatDataListY.size()) {
            throw new IllegalArgumentException("The number of observations in each group must be equal and larger than 0.");
        }
        int Tplus = 0;
        for (int j = 0; j < n; ++j) {
            double delta = flatDataListX.getDouble(j) - flatDataListY.getDouble(j);
            if (delta == 0.0 || !(delta > 0.0)) continue;
            ++Tplus;
        }
        double pvalue = SignRelatedSamples.scoreToPvalue(Tplus, n);
        return pvalue;
    }

    public static boolean test(TransposeDataList transposeDataList, boolean is_twoTailed, double aLevel) {
        if (transposeDataList.size() != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        double pvalue = SignRelatedSamples.getPvalue(transposeDataList);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n) {
        double mean = (double)n / 2.0;
        double variable = (double)n / 4.0;
        double z = (score - mean) / Math.sqrt(variable);
        return ContinuousDistributions.gaussCdf(z);
    }
}

