/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;

public class WaldWolfowitz {
    private static final AssociativeArray2D CRITICAL_VALUES = new AssociativeArray2D();

    public static boolean test(FlatDataCollection flatDataCollection, double aLevel) {
        int U = 0;
        HashMap Ni = new HashMap();
        Object previousValue = null;
        for (Object x : flatDataCollection) {
            if (previousValue != null && !previousValue.equals(x)) {
                ++U;
            }
            previousValue = x;
            if (!Ni.containsKey(x)) {
                Ni.put(x, 1);
                continue;
            }
            Ni.put(x, (Integer)Ni.get(x) + 1);
        }
        if (Ni.size() != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object[] keys = Ni.keySet().toArray();
        int n1 = (Integer)Ni.get(keys[0]);
        int n2 = (Integer)Ni.get(keys[1]);
        boolean rejectH0 = WaldWolfowitz.checkCriticalValue(U, n1, n2, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int n1, int n2, double aLevel) {
        double a;
        double variance;
        double mean;
        double z;
        double pvalue;
        boolean rejected = false;
        int n = n1 + n2;
        if (n1 <= 20 && n2 <= 20 && aLevel == 0.05) {
            int key1 = Math.max(n1, n2);
            int key2 = Math.min(n1, n2);
            Object value = CRITICAL_VALUES.get2d((Object)key1, (Object)key2);
            if (value != null) {
                String[] lowuplimit = String.valueOf(value).split(",");
                int low = Integer.parseInt(lowuplimit[0]);
                int high = n;
                if (lowuplimit.length == 2) {
                    high = Integer.parseInt(lowuplimit[1]);
                }
                if (score <= (double)low || score >= (double)high) {
                    rejected = true;
                }
                return rejected;
            }
        }
        if ((pvalue = ContinuousDistributions.gaussCdf(z = (score - (mean = 2.0 * (double)n1 * (double)n2 / ((double)n1 + (double)n2) + 1.0)) / Math.sqrt(variance = 2.0 * (double)n1 * (double)n2 * (2.0 * (double)n1 * (double)n2 - (double)n1 - (double)n2) / ((double)(n * n) * ((double)n - 1.0))))) <= (a = aLevel / 2.0) || pvalue >= 1.0 - a) {
            rejected = true;
        }
        return rejected;
    }

    static {
        CRITICAL_VALUES.put2d((Object)5, (Object)4, (Object)"2,9");
        CRITICAL_VALUES.put2d((Object)5, (Object)5, (Object)"2,10");
        CRITICAL_VALUES.put2d((Object)6, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)6, (Object)4, (Object)"2,9");
        CRITICAL_VALUES.put2d((Object)6, (Object)5, (Object)"3,10");
        CRITICAL_VALUES.put2d((Object)6, (Object)6, (Object)"3,11");
        CRITICAL_VALUES.put2d((Object)7, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)7, (Object)4, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)7, (Object)5, (Object)"3,11");
        CRITICAL_VALUES.put2d((Object)7, (Object)6, (Object)"3,12");
        CRITICAL_VALUES.put2d((Object)7, (Object)7, (Object)"3,13");
        CRITICAL_VALUES.put2d((Object)8, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)8, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)8, (Object)5, (Object)"3,11");
        CRITICAL_VALUES.put2d((Object)8, (Object)6, (Object)"3,12");
        CRITICAL_VALUES.put2d((Object)8, (Object)7, (Object)"4,13");
        CRITICAL_VALUES.put2d((Object)8, (Object)8, (Object)"4,14");
        CRITICAL_VALUES.put2d((Object)9, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)9, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)9, (Object)5, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)9, (Object)6, (Object)"4,13");
        CRITICAL_VALUES.put2d((Object)9, (Object)7, (Object)"4,14");
        CRITICAL_VALUES.put2d((Object)9, (Object)8, (Object)"5,14");
        CRITICAL_VALUES.put2d((Object)9, (Object)9, (Object)"5,15");
        CRITICAL_VALUES.put2d((Object)10, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)10, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)10, (Object)5, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)10, (Object)6, (Object)"4,13");
        CRITICAL_VALUES.put2d((Object)10, (Object)7, (Object)"5,14");
        CRITICAL_VALUES.put2d((Object)10, (Object)8, (Object)"5,15");
        CRITICAL_VALUES.put2d((Object)10, (Object)9, (Object)"5,16");
        CRITICAL_VALUES.put2d((Object)10, (Object)10, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)11, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)11, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)11, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)11, (Object)6, (Object)"4,13");
        CRITICAL_VALUES.put2d((Object)11, (Object)7, (Object)"5,14");
        CRITICAL_VALUES.put2d((Object)11, (Object)8, (Object)"5,15");
        CRITICAL_VALUES.put2d((Object)11, (Object)9, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)11, (Object)10, (Object)"6,17");
        CRITICAL_VALUES.put2d((Object)11, (Object)11, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)12, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)12, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)12, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)12, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)12, (Object)6, (Object)"4,13");
        CRITICAL_VALUES.put2d((Object)12, (Object)7, (Object)"5,14");
        CRITICAL_VALUES.put2d((Object)12, (Object)8, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)12, (Object)9, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)12, (Object)10, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)12, (Object)11, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)12, (Object)12, (Object)"7,19");
        CRITICAL_VALUES.put2d((Object)13, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)13, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)13, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)13, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)13, (Object)6, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)13, (Object)7, (Object)"5,15");
        CRITICAL_VALUES.put2d((Object)13, (Object)8, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)13, (Object)9, (Object)"6,17");
        CRITICAL_VALUES.put2d((Object)13, (Object)10, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)13, (Object)11, (Object)"7,19");
        CRITICAL_VALUES.put2d((Object)13, (Object)12, (Object)"8,19");
        CRITICAL_VALUES.put2d((Object)13, (Object)13, (Object)"8,20");
        CRITICAL_VALUES.put2d((Object)14, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)14, (Object)3, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)14, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)14, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)14, (Object)6, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)14, (Object)7, (Object)"5,15");
        CRITICAL_VALUES.put2d((Object)14, (Object)8, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)14, (Object)9, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)14, (Object)10, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)14, (Object)11, (Object)"8,19");
        CRITICAL_VALUES.put2d((Object)14, (Object)12, (Object)"8,20");
        CRITICAL_VALUES.put2d((Object)14, (Object)13, (Object)"9,20");
        CRITICAL_VALUES.put2d((Object)14, (Object)14, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)15, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)15, (Object)3, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)15, (Object)4, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)15, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)15, (Object)6, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)15, (Object)7, (Object)"6,15");
        CRITICAL_VALUES.put2d((Object)15, (Object)8, (Object)"6,16");
        CRITICAL_VALUES.put2d((Object)15, (Object)9, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)15, (Object)10, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)15, (Object)11, (Object)"8,19");
        CRITICAL_VALUES.put2d((Object)15, (Object)12, (Object)"8,20");
        CRITICAL_VALUES.put2d((Object)15, (Object)13, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)15, (Object)14, (Object)"9,22");
        CRITICAL_VALUES.put2d((Object)15, (Object)15, (Object)"10,22");
        CRITICAL_VALUES.put2d((Object)16, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)16, (Object)3, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)16, (Object)4, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)16, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)16, (Object)6, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)16, (Object)7, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)16, (Object)8, (Object)"6,17");
        CRITICAL_VALUES.put2d((Object)16, (Object)9, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)16, (Object)10, (Object)"8,19");
        CRITICAL_VALUES.put2d((Object)16, (Object)11, (Object)"8,20");
        CRITICAL_VALUES.put2d((Object)16, (Object)12, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)16, (Object)13, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)16, (Object)14, (Object)"10,22");
        CRITICAL_VALUES.put2d((Object)16, (Object)15, (Object)"10,23");
        CRITICAL_VALUES.put2d((Object)16, (Object)16, (Object)"11,23");
        CRITICAL_VALUES.put2d((Object)17, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)17, (Object)3, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)17, (Object)4, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)17, (Object)5, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)17, (Object)6, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)17, (Object)7, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)17, (Object)8, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)17, (Object)9, (Object)"7,18");
        CRITICAL_VALUES.put2d((Object)17, (Object)10, (Object)"8,19");
        CRITICAL_VALUES.put2d((Object)17, (Object)11, (Object)"9,20");
        CRITICAL_VALUES.put2d((Object)17, (Object)12, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)17, (Object)13, (Object)"10,22");
        CRITICAL_VALUES.put2d((Object)17, (Object)14, (Object)"10,23");
        CRITICAL_VALUES.put2d((Object)17, (Object)15, (Object)"11,23");
        CRITICAL_VALUES.put2d((Object)17, (Object)16, (Object)"11,24");
        CRITICAL_VALUES.put2d((Object)17, (Object)17, (Object)"11,25");
        CRITICAL_VALUES.put2d((Object)18, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)18, (Object)3, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)18, (Object)4, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)18, (Object)5, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)18, (Object)6, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)18, (Object)7, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)18, (Object)8, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)18, (Object)9, (Object)"8,18");
        CRITICAL_VALUES.put2d((Object)18, (Object)10, (Object)"8,19");
        CRITICAL_VALUES.put2d((Object)18, (Object)11, (Object)"9,20");
        CRITICAL_VALUES.put2d((Object)18, (Object)12, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)18, (Object)13, (Object)"10,22");
        CRITICAL_VALUES.put2d((Object)18, (Object)14, (Object)"10,23");
        CRITICAL_VALUES.put2d((Object)18, (Object)15, (Object)"11,24");
        CRITICAL_VALUES.put2d((Object)18, (Object)16, (Object)"11,25");
        CRITICAL_VALUES.put2d((Object)18, (Object)17, (Object)"12,25");
        CRITICAL_VALUES.put2d((Object)18, (Object)18, (Object)"12,26");
        CRITICAL_VALUES.put2d((Object)19, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)19, (Object)3, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)19, (Object)4, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)19, (Object)5, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)19, (Object)6, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)19, (Object)7, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)19, (Object)8, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)19, (Object)9, (Object)"8,18");
        CRITICAL_VALUES.put2d((Object)19, (Object)10, (Object)"8,20");
        CRITICAL_VALUES.put2d((Object)19, (Object)11, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)19, (Object)12, (Object)"10,22");
        CRITICAL_VALUES.put2d((Object)19, (Object)13, (Object)"10,23");
        CRITICAL_VALUES.put2d((Object)19, (Object)14, (Object)"11,23");
        CRITICAL_VALUES.put2d((Object)19, (Object)15, (Object)"11,24");
        CRITICAL_VALUES.put2d((Object)19, (Object)16, (Object)"12,25");
        CRITICAL_VALUES.put2d((Object)19, (Object)17, (Object)"12,26");
        CRITICAL_VALUES.put2d((Object)19, (Object)18, (Object)"13,26");
        CRITICAL_VALUES.put2d((Object)19, (Object)19, (Object)"13,27");
        CRITICAL_VALUES.put2d((Object)20, (Object)2, (Object)"2,");
        CRITICAL_VALUES.put2d((Object)20, (Object)3, (Object)"3,");
        CRITICAL_VALUES.put2d((Object)20, (Object)4, (Object)"4,");
        CRITICAL_VALUES.put2d((Object)20, (Object)5, (Object)"5,");
        CRITICAL_VALUES.put2d((Object)20, (Object)6, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)20, (Object)7, (Object)"6,");
        CRITICAL_VALUES.put2d((Object)20, (Object)8, (Object)"7,17");
        CRITICAL_VALUES.put2d((Object)20, (Object)9, (Object)"8,18");
        CRITICAL_VALUES.put2d((Object)20, (Object)10, (Object)"9,20");
        CRITICAL_VALUES.put2d((Object)20, (Object)11, (Object)"9,21");
        CRITICAL_VALUES.put2d((Object)20, (Object)12, (Object)"10,22");
        CRITICAL_VALUES.put2d((Object)20, (Object)13, (Object)"10,23");
        CRITICAL_VALUES.put2d((Object)20, (Object)14, (Object)"11,24");
        CRITICAL_VALUES.put2d((Object)20, (Object)15, (Object)"12,25");
        CRITICAL_VALUES.put2d((Object)20, (Object)16, (Object)"12,25");
        CRITICAL_VALUES.put2d((Object)20, (Object)17, (Object)"13,26");
        CRITICAL_VALUES.put2d((Object)20, (Object)18, (Object)"13,27");
        CRITICAL_VALUES.put2d((Object)20, (Object)19, (Object)"13,27");
        CRITICAL_VALUES.put2d((Object)20, (Object)20, (Object)"14,28");
    }
}

