/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.Arrays;

public class ShapiroWilk {
    public static boolean test(FlatDataCollection flatDataCollection, double aLevel) {
        double a;
        boolean rejectH0 = false;
        double probability = ShapiroWilk.shapiroWilkW(flatDataCollection.stream().filter(x -> x != null).mapToDouble(TypeInference::toDouble).toArray());
        if (probability <= (a = aLevel) || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double poly(double[] cc, int nord, double x) {
        double ret_val = cc[0];
        if (nord > 1) {
            double p = x * cc[nord - 1];
            for (int j = nord - 2; j > 0; --j) {
                p = (p + cc[j]) * x;
            }
            ret_val += p;
        }
        return ret_val;
    }

    private static int sign(double x) {
        if (x == 0.0) {
            return 0;
        }
        return x > 0.0 ? 1 : -1;
    }

    private static double shapiroWilkW(double[] x) {
        double s;
        double m;
        double xx;
        int i;
        Arrays.sort(x);
        int n = x.length;
        if (n < 3) {
            throw new IllegalArgumentException("The provided collection must have more than 2 elements.");
        }
        if (n > 5000) {
            throw new IllegalArgumentException("The provided collection must have less or equal to 5000 elements.");
        }
        int nn2 = n / 2;
        double[] a = new double[nn2 + 1];
        double small = 1.0E-19;
        double[] g = new double[]{-2.273, 0.459};
        double[] c1 = new double[]{0.0, 0.221157, -0.147981, -2.07119, 4.434685, -2.706056};
        double[] c2 = new double[]{0.0, 0.042981, -0.293762, -1.752461, 5.682633, -3.582633};
        double[] c3 = new double[]{0.544, -0.39978, 0.025054, -6.714E-4};
        double[] c4 = new double[]{1.3822, -0.77857, 0.062767, -0.0020322};
        double[] c5 = new double[]{-1.5861, -0.31082, -0.083751, 0.0038915};
        double[] c6 = new double[]{-0.4803, -0.082676, 0.0030302};
        double an = n;
        if (n == 3) {
            a[1] = 0.70710678;
        } else {
            double fac;
            int i1;
            double an25 = an + 0.25;
            double summ2 = 0.0;
            for (i = 1; i <= nn2; ++i) {
                a[i] = ContinuousDistributions.normalQuantile(((double)i - 0.375) / an25, 0.0, 1.0);
                summ2 += a[i] * a[i];
            }
            double ssumm2 = Math.sqrt(summ2 *= 2.0);
            double rsn = 1.0 / Math.sqrt(an);
            double a1 = ShapiroWilk.poly(c1, 6, rsn) - a[1] / ssumm2;
            if (n > 5) {
                i1 = 3;
                double a2 = -a[2] / ssumm2 + ShapiroWilk.poly(c2, 6, rsn);
                fac = Math.sqrt((summ2 - 2.0 * (a[1] * a[1]) - 2.0 * (a[2] * a[2])) / (1.0 - 2.0 * (a1 * a1) - 2.0 * (a2 * a2)));
                a[2] = a2;
            } else {
                i1 = 2;
                fac = Math.sqrt((summ2 - 2.0 * (a[1] * a[1])) / (1.0 - 2.0 * (a1 * a1)));
            }
            a[1] = a1;
            i = i1;
            while (i <= nn2) {
                int n2 = i++;
                a[n2] = a[n2] / -fac;
            }
        }
        double range = x[n - 1] - x[0];
        if (range < small) {
            throw new IllegalArgumentException("The range is too small.");
        }
        double sx = xx = x[0] / range;
        double sa = -a[1];
        i = 1;
        int j = n - 1;
        while (i < n) {
            double xi = x[i] / range;
            if (xx - xi > small) {
                throw new IllegalArgumentException("The xx - xi is too big.");
            }
            sx += xi;
            if (++i != j) {
                sa += (double)ShapiroWilk.sign(i - j) * a[Math.min(i, j)];
            }
            xx = xi;
            --j;
        }
        sa /= (double)n;
        sx /= (double)n;
        double sax = 0.0;
        double ssx = 0.0;
        double ssa = 0.0;
        i = 0;
        j = n - 1;
        while (i < n) {
            double asa = i != j ? (double)ShapiroWilk.sign(i - j) * a[1 + Math.min(i, j)] - sa : -sa;
            double xsx = x[i] / range - sx;
            ssa += asa * asa;
            ssx += xsx * xsx;
            sax += asa * xsx;
            ++i;
            --j;
        }
        double ssassx = Math.sqrt(ssa * ssx);
        double w1 = (ssassx - sax) * (ssassx + sax) / (ssa * ssx);
        double w = 1.0 - w1;
        if (n == 3) {
            double pi6 = 1.909859317102744;
            double stqr = 1.0471975511965976;
            double pw = pi6 * (Math.asin(Math.sqrt(w)) - stqr);
            if (pw < 0.0) {
                pw = 0.0;
            }
            return pw;
        }
        double y = Math.log(w1);
        xx = Math.log(an);
        if (n <= 11) {
            double gamma = ShapiroWilk.poly(g, 2, an);
            if (y >= gamma) {
                double pw = 1.0E-99;
                return pw;
            }
            y = -Math.log(gamma - y);
            m = ShapiroWilk.poly(c3, 4, an);
            s = Math.exp(ShapiroWilk.poly(c4, 4, an));
        } else {
            m = ShapiroWilk.poly(c5, 4, xx);
            s = Math.exp(ShapiroWilk.poly(c6, 3, xx));
        }
        double pw = ContinuousDistributions.gaussCdf((y - m) / s);
        return pw;
    }
}

