/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class Lilliefors {
    private static final DataTable2D CRITICAL_VALUES = new DataTable2D();

    public static boolean test(FlatDataCollection flatDataCollection, String cdfMethod, double aLevel) {
        double[] doubleArray = flatDataCollection.stream().filter(x -> x != null).mapToDouble(TypeInference::toDouble).toArray();
        int n = doubleArray.length;
        if (n <= 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        Arrays.sort(doubleArray);
        double observedProbabilityIminus1 = 0.0;
        double maxDelta = 0.0;
        int rank = 1;
        try {
            Method method = Lilliefors.class.getMethod(cdfMethod + "GetParams", FlatDataCollection.class);
            AssociativeArray params = (AssociativeArray)method.invoke(null, flatDataCollection);
            method = Lilliefors.class.getMethod(cdfMethod, Double.class, AssociativeArray.class);
            for (int i = 0; i < doubleArray.length; ++i) {
                double x2 = doubleArray[i];
                double observedProbabilityI = (double)rank / (double)n;
                Object[] objectArray = new Object[]{x2, params};
                Object methodResult = method.invoke(null, objectArray);
                double expectedProbabilityI = TypeInference.toDouble((Object)methodResult);
                double delta = Math.max(Math.abs(expectedProbabilityI - observedProbabilityI), Math.abs(expectedProbabilityI - observedProbabilityIminus1));
                if (delta >= maxDelta) {
                    maxDelta = delta;
                }
                observedProbabilityIminus1 = observedProbabilityI;
                ++rank;
            }
            boolean rejectH0 = Lilliefors.checkCriticalValue(maxDelta, n, aLevel);
            return rejectH0;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static AssociativeArray normalDistributionGetParams(FlatDataCollection flatDataCollection) {
        AssociativeArray params = new AssociativeArray();
        params.put((Object)"mean", (Object)Descriptives.mean(flatDataCollection));
        params.put((Object)"variance", (Object)Descriptives.variance(flatDataCollection, true));
        return params;
    }

    public static double normalDistribution(Double x, AssociativeArray params) {
        double mean = params.getDouble((Object)"mean");
        double variance = params.getDouble((Object)"variance");
        double z = (x - mean) / Math.sqrt(variance);
        return ContinuousDistributions.gaussCdf(z);
    }

    private static boolean checkCriticalValue(double score, int n, double aLevel) {
        boolean rejected = false;
        double criticalValue = Double.MAX_VALUE;
        double aLevelKey = aLevel;
        if (!CRITICAL_VALUES.containsKey((Object)aLevelKey)) {
            double significanceValue = 0.0;
            for (Map.Entry entry : CRITICAL_VALUES.entrySet()) {
                significanceValue = TypeInference.toDouble(entry.getKey());
                if (!(significanceValue <= aLevel)) continue;
                aLevelKey = significanceValue;
                break;
            }
            if (!CRITICAL_VALUES.containsKey((Object)aLevelKey)) {
                aLevelKey = significanceValue;
            }
        }
        if (CRITICAL_VALUES.containsKey((Object)aLevelKey)) {
            if (CRITICAL_VALUES.get((Object)aLevelKey).containsKey((Object)n)) {
                criticalValue = CRITICAL_VALUES.get((Object)aLevelKey).getDouble((Object)n);
            } else {
                criticalValue = CRITICAL_VALUES.get((Object)aLevelKey).getDouble((Object)0);
                criticalValue /= Math.sqrt(n);
            }
        }
        if (score > criticalValue) {
            rejected = true;
        }
        return rejected;
    }

    static {
        CRITICAL_VALUES.put2d((Object)0.2, (Object)0, (Object)0.736);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)4, (Object)0.3);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)5, (Object)0.285);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)6, (Object)0.265);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)7, (Object)0.247);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)8, (Object)0.233);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)9, (Object)0.223);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)10, (Object)0.215);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)11, (Object)0.206);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)12, (Object)0.199);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)13, (Object)0.19);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)14, (Object)0.183);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)15, (Object)0.177);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)16, (Object)0.173);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)17, (Object)0.169);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)18, (Object)0.166);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)19, (Object)0.163);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)20, (Object)0.16);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)25, (Object)0.142);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)30, (Object)0.131);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)0, (Object)0.768);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)4, (Object)0.319);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)5, (Object)0.299);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)6, (Object)0.277);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)7, (Object)0.258);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)8, (Object)0.244);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)9, (Object)0.233);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)10, (Object)0.224);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)11, (Object)0.217);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)12, (Object)0.212);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)13, (Object)0.202);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)14, (Object)0.194);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)15, (Object)0.187);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)16, (Object)0.182);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)17, (Object)0.177);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)18, (Object)0.173);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)19, (Object)0.169);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)20, (Object)0.166);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)25, (Object)0.147);
        CRITICAL_VALUES.put2d((Object)0.15, (Object)30, (Object)0.136);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)0, (Object)0.805);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)4, (Object)0.325);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)5, (Object)0.315);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)6, (Object)0.294);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)7, (Object)0.276);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)8, (Object)0.261);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)9, (Object)0.249);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)10, (Object)0.239);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)11, (Object)0.23);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)12, (Object)0.223);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)13, (Object)0.214);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)14, (Object)0.207);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)15, (Object)0.201);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)16, (Object)0.195);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)17, (Object)0.189);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)18, (Object)0.184);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)19, (Object)0.179);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)20, (Object)0.174);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)25, (Object)0.158);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)30, (Object)0.144);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)0, (Object)0.886);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)4, (Object)0.381);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)5, (Object)0.337);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)6, (Object)0.319);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)7, (Object)0.3);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)8, (Object)0.285);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)9, (Object)0.271);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)10, (Object)0.258);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)11, (Object)0.249);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)12, (Object)0.242);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)13, (Object)0.234);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)14, (Object)0.227);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)15, (Object)0.22);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)16, (Object)0.213);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)17, (Object)0.206);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)18, (Object)0.2);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)19, (Object)0.195);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)20, (Object)0.19);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)25, (Object)0.173);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)30, (Object)0.161);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)0, (Object)1.031);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)4, (Object)0.417);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)5, (Object)0.405);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)6, (Object)0.364);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)7, (Object)0.348);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)8, (Object)0.331);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)9, (Object)0.311);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)10, (Object)0.294);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)11, (Object)0.284);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)12, (Object)0.275);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)13, (Object)0.268);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)14, (Object)0.261);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)15, (Object)0.257);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)16, (Object)0.25);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)17, (Object)0.245);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)18, (Object)0.239);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)19, (Object)0.235);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)20, (Object)0.231);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)25, (Object)0.2);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)30, (Object)0.187);
    }
}

