/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.onesample;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class KolmogorovSmirnovOneSample {
    private static final DataTable2D CRITICAL_VALUES = new DataTable2D();

    public static boolean test(FlatDataCollection flatDataCollection, String cdfMethod, AssociativeArray params, boolean is_twoTailed, double aLevel) {
        double[] doubleArray = flatDataCollection.stream().filter(x -> x != null).mapToDouble(TypeInference::toDouble).toArray();
        int n = doubleArray.length;
        if (n <= 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        Arrays.sort(doubleArray);
        double observedProbabilityIminus1 = 0.0;
        double maxDelta = 0.0;
        int rank = 1;
        try {
            Method method = KolmogorovSmirnovOneSample.class.getMethod(cdfMethod, Double.class, AssociativeArray.class);
            for (int i = 0; i < doubleArray.length; ++i) {
                double x2 = doubleArray[i];
                double observedProbabilityI = (double)rank / (double)n;
                Object[] objectArray = new Object[]{x2, params};
                Object methodResult = method.invoke(null, objectArray);
                double expectedProbabilityI = TypeInference.toDouble((Object)methodResult);
                double delta = Math.max(Math.abs(expectedProbabilityI - observedProbabilityI), Math.abs(expectedProbabilityI - observedProbabilityIminus1));
                if (delta >= maxDelta) {
                    maxDelta = delta;
                }
                observedProbabilityIminus1 = observedProbabilityI;
                ++rank;
            }
            boolean rejectH0 = KolmogorovSmirnovOneSample.checkCriticalValue(maxDelta, is_twoTailed, n, aLevel);
            return rejectH0;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static double normalDistribution(Double x, AssociativeArray params) {
        double mean = params.getDouble((Object)"mean");
        double variance = params.getDouble((Object)"variance");
        double z = (x - mean) / Math.sqrt(variance);
        return ContinuousDistributions.gaussCdf(z);
    }

    private static boolean checkCriticalValue(double score, boolean is_twoTailed, int n, double aLevel) {
        double criticalValue;
        boolean rejected = false;
        if (CRITICAL_VALUES.containsKey((Object)aLevel)) {
            if (CRITICAL_VALUES.get((Object)aLevel).containsKey((Object)n)) {
                criticalValue = CRITICAL_VALUES.get((Object)aLevel).getDouble((Object)n);
            } else {
                criticalValue = CRITICAL_VALUES.get((Object)aLevel).getDouble((Object)0);
                criticalValue /= Math.sqrt((double)n + Math.sqrt((double)n / 10.0));
            }
        } else {
            criticalValue = KolmogorovSmirnovOneSample.calculateCriticalValue(is_twoTailed, n, aLevel);
        }
        if (score > criticalValue) {
            rejected = true;
        }
        return rejected;
    }

    protected static double calculateCriticalValue(boolean is_twoTailed, int n, double aLevel) {
        double sign;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        double one_minus_a = 1.0 - a;
        double Ka = 1.36;
        int direction = 1;
        if (ContinuousDistributions.kolmogorov(Ka) > one_minus_a) {
            direction = -1;
        }
        for (int i = 0; i < 110 && !((sign = (one_minus_a - ContinuousDistributions.kolmogorov(Ka += (double)direction * 0.01)) * (double)direction) <= 0.0); ++i) {
        }
        double criticalValue = Ka / Math.sqrt((double)n + Math.sqrt((double)n / 10.0));
        return criticalValue;
    }

    static {
        CRITICAL_VALUES.put2d((Object)0.2, (Object)0, (Object)1.07);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)1, (Object)0.9);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)2, (Object)0.684);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)3, (Object)0.565);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)4, (Object)0.493);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)5, (Object)0.447);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)6, (Object)0.41);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)7, (Object)0.381);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)8, (Object)0.358);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)9, (Object)0.339);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)10, (Object)0.323);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)11, (Object)0.308);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)12, (Object)0.296);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)13, (Object)0.285);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)14, (Object)0.275);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)15, (Object)0.266);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)16, (Object)0.258);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)17, (Object)0.25);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)18, (Object)0.244);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)19, (Object)0.237);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)20, (Object)0.232);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)21, (Object)0.226);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)22, (Object)0.221);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)23, (Object)0.216);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)24, (Object)0.212);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)25, (Object)0.208);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)26, (Object)0.204);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)27, (Object)0.2);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)28, (Object)0.197);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)29, (Object)0.193);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)30, (Object)0.19);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)31, (Object)0.187);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)32, (Object)0.184);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)33, (Object)0.182);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)34, (Object)0.179);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)35, (Object)0.177);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)36, (Object)0.174);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)37, (Object)0.172);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)38, (Object)0.17);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)39, (Object)0.168);
        CRITICAL_VALUES.put2d((Object)0.2, (Object)40, (Object)0.165);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)0, (Object)1.22);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)1, (Object)0.95);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)2, (Object)0.776);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)3, (Object)0.636);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)4, (Object)0.565);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)5, (Object)0.509);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)6, (Object)0.468);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)7, (Object)0.436);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)8, (Object)0.41);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)9, (Object)0.387);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)10, (Object)0.369);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)11, (Object)0.352);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)12, (Object)0.338);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)13, (Object)0.325);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)14, (Object)0.314);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)15, (Object)0.304);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)16, (Object)0.295);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)17, (Object)0.286);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)18, (Object)0.279);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)19, (Object)0.271);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)20, (Object)0.265);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)21, (Object)0.259);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)22, (Object)0.253);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)23, (Object)0.247);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)24, (Object)0.242);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)25, (Object)0.238);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)26, (Object)0.233);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)27, (Object)0.229);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)28, (Object)0.225);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)29, (Object)0.221);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)30, (Object)0.218);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)31, (Object)0.214);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)32, (Object)0.211);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)33, (Object)0.208);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)34, (Object)0.205);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)35, (Object)0.202);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)36, (Object)0.199);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)37, (Object)0.196);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)38, (Object)0.194);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)39, (Object)0.191);
        CRITICAL_VALUES.put2d((Object)0.1, (Object)40, (Object)0.189);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)0, (Object)1.36);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)1, (Object)0.975);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)2, (Object)0.842);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)3, (Object)0.708);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)4, (Object)0.624);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)5, (Object)0.563);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)6, (Object)0.519);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)7, (Object)0.483);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)8, (Object)0.454);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)9, (Object)0.43);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)10, (Object)0.409);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)11, (Object)0.391);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)12, (Object)0.375);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)13, (Object)0.361);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)14, (Object)0.349);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)15, (Object)0.338);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)16, (Object)0.327);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)17, (Object)0.318);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)18, (Object)0.309);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)19, (Object)0.301);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)20, (Object)0.294);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)21, (Object)0.287);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)22, (Object)0.281);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)23, (Object)0.275);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)24, (Object)0.269);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)25, (Object)0.264);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)26, (Object)0.259);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)27, (Object)0.254);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)28, (Object)0.25);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)29, (Object)0.246);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)30, (Object)0.242);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)31, (Object)0.238);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)32, (Object)0.234);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)33, (Object)0.231);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)34, (Object)0.227);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)35, (Object)0.224);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)36, (Object)0.221);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)37, (Object)0.218);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)38, (Object)0.215);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)39, (Object)0.213);
        CRITICAL_VALUES.put2d((Object)0.05, (Object)40, (Object)0.21);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)0, (Object)1.52);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)1, (Object)0.99);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)2, (Object)0.9);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)3, (Object)0.785);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)4, (Object)0.689);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)5, (Object)0.627);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)6, (Object)0.577);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)7, (Object)0.538);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)8, (Object)0.507);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)9, (Object)0.48);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)10, (Object)0.457);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)11, (Object)0.437);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)12, (Object)0.419);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)13, (Object)0.404);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)14, (Object)0.39);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)15, (Object)0.377);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)16, (Object)0.366);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)17, (Object)0.355);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)18, (Object)0.346);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)19, (Object)0.337);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)20, (Object)0.329);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)21, (Object)0.321);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)22, (Object)0.314);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)23, (Object)0.307);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)24, (Object)0.301);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)25, (Object)0.295);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)26, (Object)0.29);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)27, (Object)0.284);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)28, (Object)0.279);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)29, (Object)0.275);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)30, (Object)0.27);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)31, (Object)0.266);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)32, (Object)0.262);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)33, (Object)0.258);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)34, (Object)0.254);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)35, (Object)0.251);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)36, (Object)0.247);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)37, (Object)0.244);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)38, (Object)0.241);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)39, (Object)0.238);
        CRITICAL_VALUES.put2d((Object)0.02, (Object)40, (Object)0.235);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)0, (Object)1.63);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)1, (Object)0.995);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)2, (Object)0.929);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)3, (Object)0.829);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)4, (Object)0.734);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)5, (Object)0.669);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)6, (Object)0.617);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)7, (Object)0.576);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)8, (Object)0.542);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)9, (Object)0.513);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)10, (Object)0.489);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)11, (Object)0.468);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)12, (Object)0.449);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)13, (Object)0.432);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)14, (Object)0.418);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)15, (Object)0.404);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)16, (Object)0.392);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)17, (Object)0.381);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)18, (Object)0.371);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)19, (Object)0.361);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)20, (Object)0.352);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)21, (Object)0.344);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)22, (Object)0.337);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)23, (Object)0.33);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)24, (Object)0.323);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)25, (Object)0.317);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)26, (Object)0.311);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)27, (Object)0.305);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)28, (Object)0.3);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)29, (Object)0.295);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)30, (Object)0.29);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)31, (Object)0.285);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)32, (Object)0.281);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)33, (Object)0.277);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)34, (Object)0.273);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)35, (Object)0.269);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)36, (Object)0.265);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)37, (Object)0.262);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)38, (Object)0.258);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)39, (Object)0.255);
        CRITICAL_VALUES.put2d((Object)0.01, (Object)40, (Object)0.252);
    }
}

