/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Ranks;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.AbstractMap;
import java.util.Map;

public class MannWhitney {
    public static double getPvalue(TransposeDataCollection transposeDataCollection) {
        int n2;
        if (transposeDataCollection.size() != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object[] keys = transposeDataCollection.keySet().toArray();
        int smallIndex = 0;
        int largeIndex = 1;
        int n1 = transposeDataCollection.get(keys[smallIndex]).size();
        if (n1 > (n2 = transposeDataCollection.get(keys[largeIndex]).size())) {
            int tmp = n1;
            n1 = n2;
            n2 = tmp;
            smallIndex = 1;
        }
        AssociativeArray associativeArray = new AssociativeArray();
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object i = entry.getKey();
            FlatDataCollection row = (FlatDataCollection)entry.getValue();
            Integer j = 0;
            for (Object value : row) {
                AbstractMap.SimpleEntry<Object, Integer> i_j = new AbstractMap.SimpleEntry<Object, Integer>(i, j);
                associativeArray.put(i_j, value);
                j = j + 1;
            }
        }
        Ranks.getRanksFromValues(associativeArray);
        double MWscore = 0.0;
        for (Map.Entry entry : associativeArray.entrySet()) {
            Map.Entry i_j = (Map.Entry)entry.getKey();
            Object i = i_j.getKey();
            if (!i.equals(keys[smallIndex])) continue;
            Double rank = TypeInference.toDouble(entry.getValue());
            MWscore += rank.doubleValue();
        }
        double pvalue = MannWhitney.scoreToPvalue(MWscore, n1, n2);
        return pvalue;
    }

    public static boolean test(TransposeDataCollection transposeDataCollection, boolean is_twoTailed, double aLevel) {
        double pvalue = MannWhitney.getPvalue(transposeDataCollection);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n1, int n2) {
        double mean = (double)n1 * ((double)(n1 + n2) + 1.0) / 2.0;
        double variable = (double)(n1 * n2) * ((double)(n1 + n2) + 1.0) / 12.0;
        double z = (score - mean) / Math.sqrt(variable);
        return ContinuousDistributions.gaussCdf(z);
    }
}

