/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.independentsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Ranks;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class KruskalWallis {
    public static double getPvalue(TransposeDataCollection transposeDataCollection) {
        AssociativeArray associativeArray = new AssociativeArray();
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object i = entry.getKey();
            FlatDataCollection row = (FlatDataCollection)entry.getValue();
            Object j = 0;
            for (Object value : row) {
                AbstractMap.SimpleEntry i_j = new AbstractMap.SimpleEntry(i, j);
                associativeArray.put(i_j, value);
                j = (Integer)j + 1;
            }
        }
        AssociativeArray tiesCounter = Ranks.getRanksFromValues(associativeArray);
        int n = associativeArray.size();
        double C = 0.0;
        if (!tiesCounter.isEmpty()) {
            for (Object value : tiesCounter.values()) {
                double Ti = TypeInference.toDouble(value);
                C += (Ti * Ti - 1.0) * Ti;
            }
            C /= ((double)(n * n) - 1.0) * (double)n;
        }
        HashMap ni = new HashMap();
        HashMap Ridot = new HashMap();
        for (Map.Entry entry : associativeArray.entrySet()) {
            Map.Entry i_j = (Map.Entry)entry.getKey();
            Iterator i = i_j.getKey();
            Double rank = TypeInference.toDouble(entry.getValue());
            if (!Ridot.containsKey(i)) {
                Ridot.put(i, rank);
                ni.put(i, 1);
                continue;
            }
            Ridot.put(i, (Double)Ridot.get(i) + rank);
            ni.put(i, (Integer)ni.get(i) + 1);
        }
        int k = ni.size();
        double KWscore = 0.0;
        for (Map.Entry entry : Ridot.entrySet()) {
            Object i = entry.getKey();
            Double value = (Double)entry.getValue();
            KWscore += value * value / (double)((Integer)ni.get(i)).intValue();
        }
        KWscore = 12.0 / ((double)n * ((double)n + 1.0)) * KWscore - 3.0 * ((double)n + 1.0);
        double pvalue = KruskalWallis.scoreToPvalue(KWscore /= 1.0 - C, k);
        return pvalue;
    }

    public static boolean test(TransposeDataCollection transposeDataCollection, double aLevel) {
        double pvalue = KruskalWallis.getPvalue(transposeDataCollection);
        boolean rejectH0 = false;
        if (pvalue <= aLevel) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int k) {
        return 1.0 - ContinuousDistributions.chisquareCdf(score, k - 1);
    }
}

