/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.descriptivestatistics;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public class CensoredDescriptives {
    public static final String CENSORED_NUMBER_POSTFIX = "+";

    public static AssociativeArray2D survivalFunction(FlatDataCollection flatDataCollection) {
        AssociativeArray2D survivalFunction = new AssociativeArray2D();
        PriorityQueue<Double> censoredData = new PriorityQueue<Double>();
        PriorityQueue<Double> uncensoredData = new PriorityQueue<Double>();
        int n = flatDataCollection.size();
        if (n == 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        for (Object value : flatDataCollection) {
            String str = value.toString();
            if (str.endsWith(CENSORED_NUMBER_POSTFIX)) {
                censoredData.add(Double.valueOf(str.substring(0, str.length() - CENSORED_NUMBER_POSTFIX.length())));
                continue;
            }
            uncensoredData.add(TypeInference.toDouble(value));
        }
        Double currentCensored = null;
        Double currentUncensored = null;
        int i = 1;
        double previousUncensoredValue = 1.0;
        double varianceDenominator = 0.0;
        do {
            String key;
            if (currentCensored == null) {
                currentCensored = (Double)censoredData.poll();
            }
            if (currentUncensored == null) {
                currentUncensored = (Double)uncensoredData.poll();
            }
            boolean isCensored = false;
            if (currentUncensored == null) {
                key = currentCensored.toString().concat(CENSORED_NUMBER_POSTFIX);
                currentCensored = null;
                isCensored = true;
            } else if (currentCensored == null) {
                key = currentUncensored.toString();
                currentUncensored = null;
            } else if (currentCensored < currentUncensored) {
                key = currentCensored.toString().concat(CENSORED_NUMBER_POSTFIX);
                currentCensored = null;
                isCensored = true;
            } else {
                key = currentUncensored.toString();
                currentUncensored = null;
            }
            Integer previousMi = (Integer)survivalFunction.get2d((Object)key, (Object)"mi");
            if (previousMi == null) {
                previousMi = 0;
            }
            survivalFunction.put2d((Object)key, (Object)"i", (Object)i);
            survivalFunction.put2d((Object)key, (Object)"mi", (Object)(previousMi + 1));
            if (!isCensored) {
                survivalFunction.put2d((Object)key, (Object)"r", (Object)i);
                double Sti = (double)(n - i) / ((double)(n - i) + 1.0) * previousUncensoredValue;
                if (n - i > 0) {
                    varianceDenominator += 1.0 / ((double)(n - i) * ((double)(n - i) + 1.0));
                }
                survivalFunction.put2d((Object)key, (Object)"Sti", (Object)Sti);
                survivalFunction.put2d((Object)key, (Object)"varianceSti", (Object)(Sti * Sti * varianceDenominator));
                previousUncensoredValue = Sti;
            }
            ++i;
        } while (currentCensored != null || currentUncensored != null || !censoredData.isEmpty() || !uncensoredData.isEmpty());
        return survivalFunction;
    }

    public static double median(AssociativeArray2D survivalFunction) {
        Double ApointTi = null;
        Double BpointTi = null;
        int n = survivalFunction.size();
        if (n == 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        for (Map.Entry entry : survivalFunction.entrySet()) {
            Object ti = entry.getKey();
            AssociativeArray row = (AssociativeArray)entry.getValue();
            Double Sti = row.getDouble((Object)"Sti");
            if (Sti == null) continue;
            Double point = Double.valueOf(ti.toString());
            if (Math.abs(Sti - 0.5) < 1.0E-7) {
                return point;
            }
            if (Sti > 0.5) {
                ApointTi = point;
                continue;
            }
            BpointTi = point;
            break;
        }
        if (n == 1) {
            return ApointTi != null ? ApointTi : BpointTi;
        }
        if (ApointTi == null || BpointTi == null) {
            throw new IllegalArgumentException("Invalid A and B points.");
        }
        double ApointTiValue = TypeInference.toDouble((Object)survivalFunction.get2d((Object)ApointTi.toString(), (Object)"Sti"));
        double BpointTiValue = TypeInference.toDouble((Object)survivalFunction.get2d((Object)BpointTi.toString(), (Object)"Sti"));
        double median = BpointTi - (BpointTiValue - 0.5) * (BpointTi - ApointTi) / (BpointTiValue - ApointTiValue);
        return median;
    }

    public static double mean(AssociativeArray2D survivalFunction) {
        if (survivalFunction.isEmpty()) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        return CensoredDescriptives.ar(survivalFunction, 0);
    }

    private static double ar(AssociativeArray2D survivalFunction, int r) {
        if (survivalFunction.isEmpty()) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        AssociativeArray2D survivalFunctionCopy = survivalFunction;
        Map.Entry lastRowEntry = null;
        Iterator iterator = survivalFunction.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry currentRowEntry;
            lastRowEntry = currentRowEntry = (Map.Entry)iterator.next();
        }
        if (lastRowEntry == null) {
            throw new IllegalArgumentException("The last observation can't be censored.");
        }
        AssociativeArray lastRow = (AssociativeArray)lastRowEntry.getValue();
        if (lastRow.get((Object)"Sti") == null) {
            survivalFunctionCopy = survivalFunction.copy();
            Object lastRowKey = lastRowEntry.getKey();
            AssociativeArray lastRowValue = survivalFunctionCopy.remove(lastRowKey);
            String str = lastRowKey.toString();
            Double newLastRowKey = Double.valueOf(str.substring(0, str.length() - CENSORED_NUMBER_POSTFIX.length()));
            newLastRowKey = Math.floor(newLastRowKey) + 1.0;
            survivalFunctionCopy.put2d((Object)newLastRowKey, (Object)"i", lastRowValue.get((Object)"i"));
            survivalFunctionCopy.put2d((Object)newLastRowKey, (Object)"r", lastRowValue.get((Object)"i"));
            survivalFunctionCopy.put2d((Object)newLastRowKey, (Object)"Sti", (Object)0.0);
            survivalFunctionCopy.put2d((Object)newLastRowKey, (Object)"varianceSti", (Object)0.0);
        }
        double Ar = 0.0;
        double StiPrevious = 1.0;
        double tiPrevious = 0.0;
        for (Map.Entry entry : survivalFunctionCopy.entrySet()) {
            Object ti = entry.getKey();
            AssociativeArray row = (AssociativeArray)entry.getValue();
            Double Sti = row.getDouble((Object)"Sti");
            if (Sti == null) continue;
            double tiCurrent = Double.valueOf(ti.toString());
            if (row.getDouble((Object)"r") > (double)r) {
                Ar += StiPrevious * (tiCurrent - tiPrevious);
            }
            StiPrevious = Sti;
            tiPrevious = tiCurrent;
        }
        return Ar;
    }

    public static double meanVariance(AssociativeArray2D survivalFunction) {
        Number mi;
        AssociativeArray row;
        double meanVariance = 0.0;
        int m = 0;
        int n = 0;
        for (Map.Entry entry : survivalFunction.entrySet()) {
            row = (AssociativeArray)entry.getValue();
            mi = (Number)row.get((Object)"mi");
            n += mi.intValue();
            if (row.get((Object)"Sti") != null) continue;
            m += mi.intValue();
        }
        for (Map.Entry entry : survivalFunction.entrySet()) {
            row = (AssociativeArray)entry.getValue();
            if (row.get((Object)"Sti") == null) continue;
            mi = (Number)row.get((Object)"mi");
            Number r = (Number)row.get((Object)"r");
            double Ar = CensoredDescriptives.ar(survivalFunction, r.intValue());
            if (n - r.intValue() <= 0) continue;
            meanVariance += (double)mi.intValue() * (Ar * Ar) / ((double)(n - r.intValue()) * ((double)(n - r.intValue()) + 1.0));
        }
        return meanVariance *= (double)m / ((double)m - 1.0);
    }

    public static double meanStd(AssociativeArray2D survivalFunction) {
        return Math.sqrt(CensoredDescriptives.meanVariance(survivalFunction));
    }
}

