/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.anova;

import com.datumbox.framework.common.dataobjects.AssociativeArray2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection;
import com.datumbox.framework.common.dataobjects.TransposeDataCollection2D;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Anova {
    public static boolean oneWayTestEqualVars(TransposeDataCollection transposeDataCollection, double aLevel, AssociativeArray2D outputTable) {
        int n = 0;
        int k = transposeDataCollection.size();
        if (k <= 1) {
            throw new IllegalArgumentException("The collection must contain observations from at least 2 groups.");
        }
        HashMap nj = new HashMap();
        double Ymean = 0.0;
        HashMap Yjmean = new HashMap();
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = (FlatDataCollection)entry.getValue();
            int m = flatDataCollection.size();
            if (m == 0) {
                throw new IllegalArgumentException("The number of observations in each group but be larger than 0.");
            }
            nj.put(j, m);
            n += m;
            double sum = Descriptives.sum(flatDataCollection);
            Yjmean.put(j, sum / (double)m);
            Ymean += sum;
        }
        if (n - k <= 0) {
            throw new IllegalArgumentException("The number of observations must be larger than the number of groups.");
        }
        Ymean /= (double)n;
        double RSS = 0.0;
        double BSS = 0.0;
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = (FlatDataCollection)entry.getValue();
            Iterator it = flatDataCollection.iteratorDouble();
            while (it.hasNext()) {
                RSS += Math.pow((Double)it.next() - (Double)Yjmean.get(j), 2.0);
            }
            BSS += (double)((Integer)nj.get(j)).intValue() * Math.pow((Double)Yjmean.get(j) - Ymean, 2.0);
        }
        double F = BSS / (double)(k - 1) / (RSS / (double)(n - k));
        double pvalue = ContinuousDistributions.fCdf(F, k - 1, n - k);
        boolean rejectH0 = false;
        double a = aLevel / 2.0;
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        if (outputTable != null) {
            double TSS = RSS + BSS;
            outputTable.clear();
            outputTable.put2d((Object)"BG", (Object)"SSq", (Object)BSS);
            outputTable.put2d((Object)"BG", (Object)"DF", (Object)(k - 1));
            outputTable.put2d((Object)"BG", (Object)"MSq", (Object)(BSS / (double)(k - 1)));
            outputTable.put2d((Object)"BG", (Object)"F", (Object)F);
            outputTable.put2d((Object)"BG", (Object)"p", (Object)(1.0 - pvalue));
            outputTable.put2d((Object)"WG", (Object)"SSq", (Object)RSS);
            outputTable.put2d((Object)"WG", (Object)"DF", (Object)(n - k));
            outputTable.put2d((Object)"WG", (Object)"MSq", (Object)(RSS / (double)(n - k)));
            outputTable.put2d((Object)"R", (Object)"SSq", (Object)TSS);
            outputTable.put2d((Object)"R", (Object)"DF", (Object)(n - 1));
        }
        return rejectH0;
    }

    public static boolean oneWayTestEqualVars(TransposeDataCollection transposeDataCollection, double aLevel) {
        return Anova.oneWayTestEqualVars(transposeDataCollection, aLevel, null);
    }

    public static boolean oneWayTestNotEqualVars(TransposeDataCollection transposeDataCollection, double aLevel, AssociativeArray2D outputTable) {
        int n = 0;
        int k = transposeDataCollection.size();
        if (k <= 1) {
            throw new IllegalArgumentException("The collection must contain observations from at least 2 groups.");
        }
        HashMap nj = new HashMap();
        double Ymean = 0.0;
        HashMap Yjmean = new HashMap();
        HashMap Yjvariance = new HashMap();
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            FlatDataCollection flatDataCollection = (FlatDataCollection)entry.getValue();
            int m = flatDataCollection.size();
            if (m == 0) {
                throw new IllegalArgumentException("The number of observations in each group but be larger than 0.");
            }
            nj.put(j, m);
            n += m;
            double sum = Descriptives.sum(flatDataCollection);
            Yjmean.put(j, sum / (double)m);
            Ymean += sum;
            Yjvariance.put(j, Descriptives.variance(flatDataCollection, true));
        }
        if (n - k <= 0) {
            throw new IllegalArgumentException("The number of observations must be larger than the number of groups.");
        }
        Ymean /= (double)n;
        double BSS = 0.0;
        HashMap<Iterator<Object>, Double> mj = new HashMap<Iterator<Object>, Double>();
        double mjSum = 0.0;
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Iterator<Object> j = entry.getKey();
            BSS += (double)((Integer)nj.get(j)).intValue() * Math.pow((Double)Yjmean.get(j) - Ymean, 2.0);
            mj.put(j, (1.0 - (double)((Integer)nj.get(j)).intValue() / (double)n) * (Double)Yjvariance.get(j));
            mjSum += ((Double)mj.get(j)).doubleValue();
        }
        double dfDenominator = 0.0;
        for (Map.Entry entry : transposeDataCollection.entrySet()) {
            Object j = entry.getKey();
            dfDenominator += Math.pow((Double)mj.get(j) / mjSum, 2.0) / ((double)((Integer)nj.get(j)).intValue() - 1.0);
        }
        int df = (int)Math.round(1.0 / dfDenominator);
        double Fstar = BSS / mjSum;
        double pvalue = ContinuousDistributions.fCdf(Fstar, k - 1, df);
        boolean rejectH0 = false;
        double a = aLevel / 2.0;
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        if (outputTable != null) {
            outputTable.clear();
            outputTable.put2d((Object)"BG", (Object)"Fparts", (Object)BSS);
            outputTable.put2d((Object)"BG", (Object)"DF", (Object)(k - 1));
            outputTable.put2d((Object)"BG", (Object)"F", (Object)Fstar);
            outputTable.put2d((Object)"BG", (Object)"p", (Object)(1.0 - pvalue));
            outputTable.put2d((Object)"WG", (Object)"Fparts", (Object)mjSum);
            outputTable.put2d((Object)"WG", (Object)"DF", (Object)df);
        }
        return rejectH0;
    }

    public static boolean oneWayTestNotEqualVars(TransposeDataCollection transposeDataCollection, double aLevel) {
        return Anova.oneWayTestNotEqualVars(transposeDataCollection, aLevel, null);
    }

    public static boolean twoWayTestEqualCellsEqualVars(TransposeDataCollection2D twoFactorDataCollection, double aLevel, AssociativeArray2D outputTable) {
        Object i;
        Integer Itotal = twoFactorDataCollection.size();
        Integer Jtotal = null;
        for (Map.Entry entry : twoFactorDataCollection.entrySet()) {
            if (Jtotal != null) {
                if (Jtotal.intValue() == ((TransposeDataCollection)entry.getValue()).size()) continue;
                throw new IllegalArgumentException("The cells must be of equal size.");
            }
            Jtotal = ((TransposeDataCollection)entry.getValue()).size();
            if (Jtotal != 0) continue;
            throw new IllegalArgumentException("The size of Jtotal must be larger than 0.");
        }
        int n = 0;
        HashMap nidotdot = new HashMap();
        HashMap ndotjdot = new HashMap();
        HashMap nijdot = new HashMap();
        double Ydotdotdot = 0.0;
        HashMap Yidotdot = new HashMap();
        HashMap Ydotjdot = new HashMap();
        HashMap Yijdot = new HashMap();
        for (Map.Entry entry : twoFactorDataCollection.entrySet()) {
            Object IfactorAlevel = entry.getKey();
            TransposeDataCollection listOfBlevels = (TransposeDataCollection)entry.getValue();
            if (!Yidotdot.containsKey(IfactorAlevel)) {
                Yidotdot.put(IfactorAlevel, 0.0);
                nidotdot.put(IfactorAlevel, 0);
                Yijdot.put(IfactorAlevel, new HashMap());
                nijdot.put(IfactorAlevel, new HashMap());
            }
            for (Map.Entry entry2 : listOfBlevels.entrySet()) {
                Object JfactorBlevel = entry2.getKey();
                FlatDataCollection flatDataCollection = (FlatDataCollection)entry2.getValue();
                if (!Ydotjdot.containsKey(JfactorBlevel)) {
                    Ydotjdot.put(JfactorBlevel, 0.0);
                    ndotjdot.put(JfactorBlevel, 0);
                }
                if (!((Map)Yijdot.get(IfactorAlevel)).containsKey(JfactorBlevel)) {
                    ((Map)Yijdot.get(IfactorAlevel)).put(JfactorBlevel, 0.0);
                    ((Map)nijdot.get(IfactorAlevel)).put(JfactorBlevel, 0);
                }
                Iterator it = flatDataCollection.iteratorDouble();
                while (it.hasNext()) {
                    Double value = (Double)it.next();
                    Ydotdotdot += value.doubleValue();
                    ++n;
                    Yidotdot.put(IfactorAlevel, (Double)Yidotdot.get(IfactorAlevel) + value);
                    nidotdot.put(IfactorAlevel, (Integer)nidotdot.get(IfactorAlevel) + 1);
                    Ydotjdot.put(JfactorBlevel, (Double)Ydotjdot.get(JfactorBlevel) + value);
                    ndotjdot.put(JfactorBlevel, (Integer)ndotjdot.get(JfactorBlevel) + 1);
                    ((Map)Yijdot.get(IfactorAlevel)).put(JfactorBlevel, (Double)((Map)Yijdot.get(IfactorAlevel)).get(JfactorBlevel) + value);
                    ((Map)nijdot.get(IfactorAlevel)).put(JfactorBlevel, (Integer)((Map)nijdot.get(IfactorAlevel)).get(JfactorBlevel) + 1);
                }
            }
        }
        Ydotdotdot /= (double)n;
        for (Map.Entry entry : Yidotdot.entrySet()) {
            i = entry.getKey();
            Yidotdot.put(i, (Double)entry.getValue() / (double)((Integer)nidotdot.get(i)).intValue());
        }
        for (Map.Entry entry : Ydotjdot.entrySet()) {
            Object j = entry.getKey();
            Ydotjdot.put(j, (Double)entry.getValue() / (double)((Integer)ndotjdot.get(j)).intValue());
        }
        for (Map.Entry entry : Yijdot.entrySet()) {
            i = entry.getKey();
            Map listOfYj = (Map)entry.getValue();
            for (Map.Entry entry3 : listOfYj.entrySet()) {
                Object j = entry3.getKey();
                Double value = (Double)entry3.getValue();
                ((Map)Yijdot.get(i)).put(j, value / (double)((Integer)((Map)nijdot.get(i)).get(j)).intValue());
            }
        }
        double SSA = 0.0;
        double SSB = 0.0;
        double SSAB = 0.0;
        double SST = 0.0;
        for (Map.Entry entry1 : twoFactorDataCollection.entrySet()) {
            Object IfactorAlevel = entry1.getKey();
            TransposeDataCollection listOfBlevels = (TransposeDataCollection)entry1.getValue();
            for (Map.Entry entry2 : listOfBlevels.entrySet()) {
                Object JfactorBlevel = entry2.getKey();
                FlatDataCollection flatDataCollection = (FlatDataCollection)entry2.getValue();
                Iterator it = flatDataCollection.iteratorDouble();
                while (it.hasNext()) {
                    Double value = (Double)it.next();
                    SST += Math.pow(value - Ydotdotdot, 2.0);
                    SSA += Math.pow((Double)Yidotdot.get(IfactorAlevel) - Ydotdotdot, 2.0);
                    SSB += Math.pow((Double)Ydotjdot.get(JfactorBlevel) - Ydotdotdot, 2.0);
                    SSAB += Math.pow((Double)((Map)Yijdot.get(IfactorAlevel)).get(JfactorBlevel) - (Double)Yidotdot.get(IfactorAlevel) - (Double)Ydotjdot.get(JfactorBlevel) + Ydotdotdot, 2.0);
                }
            }
        }
        double SSE = SST - SSA - SSB - SSAB;
        double SSR = SSA + SSB + SSAB;
        int dfA = Itotal - 1;
        double MSA = SSA / (double)dfA;
        int dfB = Jtotal - 1;
        double MSB = SSB / (double)dfB;
        int dfAB = (Itotal - 1) * (Jtotal - 1);
        double MSAB = SSAB / (double)dfAB;
        int dfE = n - Itotal * Jtotal;
        double MSE = SSE / (double)dfE;
        int dfR = dfA + dfB + dfAB;
        double MSR = SSR / (double)dfR;
        double FA = MSA / MSE;
        double Apvalue = ContinuousDistributions.fCdf(FA, dfA, dfE);
        double FB = MSB / MSE;
        double Bpvalue = ContinuousDistributions.fCdf(FB, dfB, dfE);
        double FAB = MSAB / MSE;
        double ABpvalue = ContinuousDistributions.fCdf(FAB, dfAB, dfE);
        double FR = MSR / MSE;
        double Rpvalue = ContinuousDistributions.fCdf(FR, dfR, dfE);
        boolean rejectH0 = false;
        double a = aLevel / 2.0;
        if (Rpvalue <= a || Rpvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        if (outputTable != null) {
            outputTable.clear();
            outputTable.put2d((Object)"Model", (Object)"SSq", (Object)SSR);
            outputTable.put2d((Object)"Model", (Object)"DF", (Object)dfR);
            outputTable.put2d((Object)"Model", (Object)"MSq", (Object)MSR);
            outputTable.put2d((Object)"Model", (Object)"F", (Object)FR);
            outputTable.put2d((Object)"Model", (Object)"p", (Object)(1.0 - Rpvalue));
            outputTable.put2d((Object)"AFactor", (Object)"SSq", (Object)SSA);
            outputTable.put2d((Object)"AFactor", (Object)"DF", (Object)dfA);
            outputTable.put2d((Object)"AFactor", (Object)"MSq", (Object)MSA);
            outputTable.put2d((Object)"AFactor", (Object)"F", (Object)FA);
            outputTable.put2d((Object)"AFactor", (Object)"p", (Object)(1.0 - Apvalue));
            outputTable.put2d((Object)"BFactor", (Object)"SSq", (Object)SSB);
            outputTable.put2d((Object)"BFactor", (Object)"DF", (Object)dfB);
            outputTable.put2d((Object)"BFactor", (Object)"MSq", (Object)MSB);
            outputTable.put2d((Object)"BFactor", (Object)"F", (Object)FB);
            outputTable.put2d((Object)"BFactor", (Object)"p", (Object)(1.0 - Bpvalue));
            outputTable.put2d((Object)"A*BFactor", (Object)"SSq", (Object)SSAB);
            outputTable.put2d((Object)"A*BFactor", (Object)"DF", (Object)dfAB);
            outputTable.put2d((Object)"A*BFactor", (Object)"MSq", (Object)MSAB);
            outputTable.put2d((Object)"A*BFactor", (Object)"F", (Object)FAB);
            outputTable.put2d((Object)"A*BFactor", (Object)"p", (Object)(1.0 - ABpvalue));
            outputTable.put2d((Object)"Error", (Object)"SSq", (Object)SSE);
            outputTable.put2d((Object)"Error", (Object)"DF", (Object)dfE);
            outputTable.put2d((Object)"Error", (Object)"MSq", (Object)MSE);
            outputTable.put2d((Object)"Total", (Object)"SSq", (Object)SST);
            outputTable.put2d((Object)"Total", (Object)"DF", (Object)(n - 1));
        }
        return rejectH0;
    }

    public static boolean twoWayTestEqualCellsEqualVars(TransposeDataCollection2D twoFactorDataCollection, double aLevel) {
        return Anova.twoWayTestEqualCellsEqualVars(twoFactorDataCollection, aLevel, null);
    }
}

