/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.mathematics.distances;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Distance {
    public static double euclidean(AssociativeArray a1, AssociativeArray a2) {
        Map<Object, Double> columnDistances = Distance.columnDistances(a1, a2, null);
        double distance = 0.0;
        for (double columnDistance : columnDistances.values()) {
            distance += columnDistance * columnDistance;
        }
        return Math.sqrt(distance);
    }

    public static double euclideanWeighted(AssociativeArray a1, AssociativeArray a2, Map<Object, Double> columnWeights) {
        Map<Object, Double> columnDistances = Distance.columnDistances(a1, a2, columnWeights.keySet());
        double distance = 0.0;
        for (Map.Entry<Object, Double> entry : columnDistances.entrySet()) {
            double columnDistance = entry.getValue();
            distance += columnDistance * columnDistance * columnWeights.get(entry.getKey());
        }
        return Math.sqrt(distance);
    }

    public static double manhattan(AssociativeArray a1, AssociativeArray a2) {
        Map<Object, Double> columnDistances = Distance.columnDistances(a1, a2, null);
        double distance = 0.0;
        for (double columnDistance : columnDistances.values()) {
            distance += Math.abs(columnDistance);
        }
        return distance;
    }

    public static double manhattanWeighted(AssociativeArray a1, AssociativeArray a2, Map<Object, Double> columnWeights) {
        Map<Object, Double> columnDistances = Distance.columnDistances(a1, a2, columnWeights.keySet());
        double distance = 0.0;
        for (Map.Entry<Object, Double> entry : columnDistances.entrySet()) {
            distance += Math.abs(entry.getValue()) * columnWeights.get(entry.getKey());
        }
        return distance;
    }

    public static double maximum(AssociativeArray a1, AssociativeArray a2) {
        Map<Object, Double> columnDistances = Distance.columnDistances(a1, a2, null);
        double distance = 0.0;
        for (double columnDistance : columnDistances.values()) {
            if (!(distance < (columnDistance = Math.abs(columnDistance)))) continue;
            distance = columnDistance;
        }
        return distance;
    }

    private static Map<Object, Double> columnDistances(AssociativeArray a1, AssociativeArray a2, Set<Object> comparingColumns) {
        if (comparingColumns == null) {
            comparingColumns = new HashSet<Object>(a1.keySet());
            comparingColumns.addAll(a2.keySet());
        }
        HashMap<Object, Double> columnDistances = new HashMap<Object, Double>();
        for (Object column : comparingColumns) {
            Object v2;
            Object v1 = a1.get(column);
            if (Objects.equals(v1, v2 = a2.get(column))) {
                columnDistances.put(column, 0.0);
                continue;
            }
            if (v1 == null || v2 == null) {
                Object nonNullObject = v1 != null ? v1 : v2;
                TypeInference.DataType type = TypeInference.getDataType((Object)nonNullObject);
                if (type == TypeInference.DataType.NUMERICAL || type == TypeInference.DataType.BOOLEAN) {
                    columnDistances.put(column, TypeInference.toDouble((Object)nonNullObject));
                    continue;
                }
                columnDistances.put(column, 1.0);
                continue;
            }
            TypeInference.DataType type = TypeInference.getDataType((Object)v1);
            if (type == TypeInference.DataType.NUMERICAL || type == TypeInference.DataType.BOOLEAN) {
                columnDistances.put(column, TypeInference.toDouble((Object)v1) - TypeInference.toDouble((Object)v2));
                continue;
            }
            columnDistances.put(column, 1.0);
        }
        return columnDistances;
    }
}

