/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.recommendation;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.common.utilities.MapMethods;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractRecommender;
import com.datumbox.framework.core.mathematics.distances.Distance;
import com.datumbox.framework.core.statistics.parametrics.relatedsamples.PearsonCorrelation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CollaborativeFiltering
extends AbstractRecommender<ModelParameters, TrainingParameters> {
    protected CollaborativeFiltering(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected CollaborativeFiltering(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _predict(Dataframe newData) {
        Map<List<Object>, Double> similarities = ((ModelParameters)this.knowledgeBase.getModelParameters()).getSimilarities();
        for (Map.Entry<Integer, Record> e : newData.entries()) {
            Double score;
            Integer rId = e.getKey();
            Record r = e.getValue();
            Map<Object, Double> recommendations = new HashMap();
            HashMap<Object, Double> simSums = new HashMap<Object, Double>();
            for (Map.Entry entry : r.getX().entrySet()) {
                Object row = entry.getKey();
                score = TypeInference.toDouble(entry.getValue());
                for (Map.Entry<List<Object>, Double> entry2 : similarities.entrySet()) {
                    List<Object> tpk = entry2.getKey();
                    if (!tpk.get(0).equals(row)) continue;
                    Object column = tpk.get(1);
                    Double previousRecValue = recommendations.getOrDefault(column, 0.0);
                    Double previousSimsumValue = simSums.getOrDefault(column, 0.0);
                    Double similarity = entry2.getValue();
                    recommendations.put(column, previousRecValue + similarity * score);
                    simSums.put(column, previousSimsumValue + similarity);
                }
            }
            for (Map.Entry entry : recommendations.entrySet()) {
                Object column = entry.getKey();
                score = (Double)entry.getValue();
                recommendations.put(column, score / (Double)simSums.get(column));
            }
            recommendations = MapMethods.sortNumberMapByValueDescending(recommendations);
            newData._unsafe_set(rId, new Record(r.getX(), r.getY(), recommendations.keySet().iterator().next(), new AssociativeArray(recommendations)));
        }
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<List<Object>, Double> similarities = modelParameters.getSimilarities();
        for (Record r1 : trainingData) {
            Object y1 = r1.getY();
            for (Record r2 : trainingData) {
                Object y2 = r2.getY();
                List<Object> tkp = Arrays.asList(y1, y2);
                if (similarities.containsKey(tkp)) continue;
                double similarity = this.calculateSimilarity(r1, r2);
                similarities.put(tkp, similarity);
                similarities.put(Arrays.asList(y2, y1), similarity);
            }
        }
    }

    private double calculateSimilarity(Record r1, Record r2) {
        double similarity;
        TrainingParameters trainingParameters = (TrainingParameters)this.knowledgeBase.getTrainingParameters();
        TrainingParameters.SimilarityMeasure similarityMethod = trainingParameters.getSimilarityMethod();
        if (similarityMethod == TrainingParameters.SimilarityMeasure.EUCLIDIAN) {
            similarity = Distance.euclidean(r1.getX(), r2.getX());
            similarity = 1.0 / (1.0 + similarity);
        } else if (similarityMethod == TrainingParameters.SimilarityMeasure.MANHATTAN) {
            similarity = Distance.manhattan(r1.getX(), r2.getX());
            similarity = 1.0 / (1.0 + similarity);
        } else if (similarityMethod == TrainingParameters.SimilarityMeasure.PEARSONS_CORRELATION) {
            HashSet commonColumns = new HashSet(r1.getX().keySet());
            commonColumns.addAll(r2.getX().keySet());
            FlatDataList flatDataList1 = new FlatDataList();
            FlatDataList flatDataList2 = new FlatDataList();
            for (Object column : commonColumns) {
                flatDataList1.add((Object)TypeInference.toDouble((Object)r1.getX().get(column)));
                flatDataList2.add((Object)TypeInference.toDouble((Object)r2.getX().get(column)));
            }
            TransposeDataList transposeDataList = new TransposeDataList();
            transposeDataList.put((Object)1, flatDataList1);
            transposeDataList.put((Object)2, flatDataList2);
            similarity = PearsonCorrelation.calculateCorrelation(transposeDataList);
            similarity = (similarity + 1.0) / 2.0;
        } else {
            throw new IllegalArgumentException("Unsupported Distance method.");
        }
        return similarity;
    }

    public static class TrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
        private SimilarityMeasure similarityMethod = SimilarityMeasure.EUCLIDIAN;

        public SimilarityMeasure getSimilarityMethod() {
            return this.similarityMethod;
        }

        public void setSimilarityMethod(SimilarityMeasure similarityMethod) {
            this.similarityMethod = similarityMethod;
        }

        public static enum SimilarityMeasure {
            EUCLIDIAN,
            MANHATTAN,
            PEARSONS_CORRELATION;

        }
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=List.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_CACHE, concurrent=false)
        private Map<List<Object>, Double> similarities;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<List<Object>, Double> getSimilarities() {
            return this.similarities;
        }

        protected void setSimilarities(Map<List<Object>, Double> similarities) {
            this.similarities = similarities;
        }
    }
}

