/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.preprocessing;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractScaler;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class StandardScaler
extends AbstractScaler<ModelParameters, TrainingParameters> {
    protected StandardScaler(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected StandardScaler(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> meanColumnValues = modelParameters.getMeanColumnValues();
        Map<Object, Double> stdColumnValues = modelParameters.getStdColumnValues();
        boolean scaleResponse = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getScaleResponse();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Stream<Object> transformedColumns = trainingData.getXDataTypes().entrySet().stream().filter(e -> supportedXDataTypes.contains(e.getValue())).map(e -> e.getKey());
        this.streamExecutor.forEach(StreamMethods.stream(transformedColumns, (boolean)this.isParallelized()), column -> {
            FlatDataCollection columnValues = trainingData.getXColumn(column).toFlatDataCollection();
            meanColumnValues.put(column, Descriptives.mean(columnValues));
            stdColumnValues.put(column, Descriptives.std(columnValues, true));
        });
        if (scaleResponse && trainingData.getYDataType() == TypeInference.DataType.NUMERICAL) {
            FlatDataCollection columnValues = trainingData.getYColumn().toFlatDataCollection();
            meanColumnValues.put("~Y", Descriptives.mean(columnValues));
            stdColumnValues.put("~Y", Descriptives.std(columnValues, true));
        }
    }

    @Override
    protected void _transform(Dataframe newData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> meanColumnValues = modelParameters.getMeanColumnValues();
        Map<Object, Double> stdColumnValues = modelParameters.getStdColumnValues();
        boolean scaleResponse = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getScaleResponse() && meanColumnValues.containsKey("~Y");
        this.streamExecutor.forEach(StreamMethods.stream(newData.entries(), (boolean)this.isParallelized()), e -> {
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            Object yData = r.getY();
            boolean modified = false;
            for (Object column : r.getX().keySet()) {
                Double mean = (Double)meanColumnValues.get(column);
                if (mean == null) continue;
                Object value = xData.remove(column);
                if (value != null) {
                    Double std = (Double)stdColumnValues.get(column);
                    xData.put(column, (Object)this.scale(TypeInference.toDouble((Object)value), mean, std));
                }
                modified = true;
            }
            if (scaleResponse && yData != null) {
                Double value = TypeInference.toDouble((Object)yData);
                Double mean = (Double)meanColumnValues.get("~Y");
                Double std = (Double)stdColumnValues.get("~Y");
                yData = this.scale(value, mean, std);
                modified = true;
            }
            if (modified) {
                Integer rId = (Integer)e.getKey();
                Record newR = new Record(xData, yData, r.getYPredicted(), r.getYPredictedProbabilities());
                newData._unsafe_set(rId, newR);
            }
        });
    }

    private Double scale(Double value, Double mean, Double std) {
        if (std.equals(0.0)) {
            if (value > mean) {
                return 1.0;
            }
            if (value < mean) {
                return -1.0;
            }
            return Math.signum(value);
        }
        return (value - mean) / std;
    }

    public static class TrainingParameters
    extends AbstractScaler.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractScaler.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Double> meanColumnValues;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Double> stdColumnValues;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Double> getMeanColumnValues() {
            return this.meanColumnValues;
        }

        protected void setMeanColumnValues(Map<Object, Double> meanColumnValues) {
            this.meanColumnValues = meanColumnValues;
        }

        public Map<Object, Double> getStdColumnValues() {
            return this.stdColumnValues;
        }

        protected void setStdColumnValues(Map<Object, Double> stdColumnValues) {
            this.stdColumnValues = stdColumnValues;
        }
    }
}

