/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.preprocessing;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class OneHotEncoder
extends AbstractEncoder<ModelParameters, TrainingParameters> {
    protected OneHotEncoder(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected OneHotEncoder(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
    }

    @Override
    protected void _transform(Dataframe newData) {
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Map<Object, TypeInference.DataType> xDataTypes = newData.getXDataTypes();
        this.streamExecutor.forEach(StreamMethods.stream(newData.entries(), (boolean)this.isParallelized()), e -> {
            Integer rId = (Integer)e.getKey();
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            boolean modified = false;
            for (Object column : r.getX().keySet()) {
                if (!supportedXDataTypes.contains(xDataTypes.get(column))) continue;
                Object value = xData.remove(column);
                if (value != null) {
                    xData.put(Arrays.asList(column, value), (Object)true);
                }
                modified = true;
            }
            if (modified) {
                Record newR = new Record(xData, r.getY(), r.getYPredicted(), r.getYPredictedProbabilities());
                newData._unsafe_set(rId, newR);
            }
        });
        newData.recalculateMeta();
    }

    public static class TrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

