/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.modelselection.metrics;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelselection.AbstractMetrics;
import java.util.List;
import java.util.Map;

public class RecommendationMetrics
extends AbstractMetrics {
    private static final long serialVersionUID = 1L;
    private double RMSE = 0.0;

    public double getRMSE() {
        return this.RMSE;
    }

    public RecommendationMetrics(Dataframe predictedData) {
        super(predictedData);
        int i = 0;
        for (Record r : predictedData) {
            AssociativeArray predictions = r.getYPredictedProbabilities();
            for (Map.Entry entry : r.getX().entrySet()) {
                Object column = entry.getKey();
                Object value = entry.getValue();
                this.RMSE += Math.pow(TypeInference.toDouble(value) - TypeInference.toDouble((Object)predictions.get(column)), 2.0);
                ++i;
            }
        }
        this.RMSE = Math.sqrt(this.RMSE / (double)i);
    }

    public RecommendationMetrics(List<RecommendationMetrics> validationMetricsList) {
        super(validationMetricsList);
        if (!validationMetricsList.isEmpty()) {
            int k = validationMetricsList.size();
            for (RecommendationMetrics vmSample : validationMetricsList) {
                this.RMSE += vmSample.getRMSE() / (double)k;
            }
        }
    }

    public String toString() {
        String sep = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(":").append(sep);
        sb.append("RMSE=").append(this.RMSE).append(sep);
        return sb.toString();
    }
}

