/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.ensemblelearning;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.utilities.MapMethods;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.ArrayList;
import java.util.Map;

public class FixedCombinationRules {
    public static AssociativeArray sum(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                Double probability = TypeInference.toDouble(entry2.getValue());
                Double previousValue = combinedClassProbabilities.getDouble(theClass);
                if (previousValue == null) {
                    previousValue = 0.0;
                }
                combinedClassProbabilities.put(theClass, (Object)(previousValue + probability));
            }
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray average(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        int numberOfClasses = classifierClassProbabilityMatrix.size();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                Double probability = TypeInference.toDouble(entry2.getValue());
                Double previousValue = combinedClassProbabilities.getDouble(theClass);
                if (previousValue == null) {
                    previousValue = 0.0;
                }
                combinedClassProbabilities.put(theClass, (Object)(previousValue + probability / (double)numberOfClasses));
            }
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray weightedAverage(DataTable2D classifierClassProbabilityMatrix, AssociativeArray classifierWeights) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            Object classifier = entry.getKey();
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            Double classifierWeight = classifierWeights.getDouble(classifier);
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                Double probability = TypeInference.toDouble(entry2.getValue());
                Double previousValue = combinedClassProbabilities.getDouble(theClass);
                if (previousValue == null) {
                    previousValue = 0.0;
                }
                combinedClassProbabilities.put(theClass, (Object)(previousValue + probability * classifierWeight));
            }
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray median(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                combinedClassProbabilities.put(theClass, (Object)0.0);
            }
        }
        for (Map.Entry entry : combinedClassProbabilities.entrySet()) {
            Object theClass = entry.getKey();
            FlatDataCollection listOfProbabilities = new FlatDataCollection(new ArrayList());
            for (Map.Entry entry2 : classifierClassProbabilityMatrix.entrySet()) {
                AssociativeArray listOfClassProbabilities = (AssociativeArray)entry2.getValue();
                Double probability = listOfClassProbabilities.getDouble(theClass);
                if (probability == null) continue;
                listOfProbabilities.add((Object)probability);
            }
            combinedClassProbabilities.put(theClass, (Object)Descriptives.median(listOfProbabilities));
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray maximum(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                Double probability = TypeInference.toDouble(entry2.getValue());
                Double previousValue = combinedClassProbabilities.getDouble(theClass);
                if (previousValue != null && !(probability > previousValue)) continue;
                combinedClassProbabilities.put(theClass, (Object)probability);
            }
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray minimum(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                Double probability = TypeInference.toDouble(entry2.getValue());
                Double previousValue = combinedClassProbabilities.getDouble(theClass);
                if (previousValue != null && !(probability < previousValue)) continue;
                combinedClassProbabilities.put(theClass, (Object)probability);
            }
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray product(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            AssociativeArray listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                Double probability = TypeInference.toDouble(entry2.getValue());
                Double previousValue = combinedClassProbabilities.getDouble(theClass);
                if (previousValue == null) {
                    previousValue = 1.0;
                }
                combinedClassProbabilities.put(theClass, (Object)(previousValue * probability));
            }
        }
        return combinedClassProbabilities;
    }

    public static AssociativeArray majorityVote(DataTable2D classifierClassProbabilityMatrix) {
        AssociativeArray listOfClassProbabilities;
        AssociativeArray combinedClassProbabilities = new AssociativeArray();
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            listOfClassProbabilities = (AssociativeArray)entry.getValue();
            for (Map.Entry entry2 : listOfClassProbabilities.entrySet()) {
                Object theClass = entry2.getKey();
                combinedClassProbabilities.put(theClass, (Object)0.0);
            }
        }
        for (Map.Entry entry : classifierClassProbabilityMatrix.entrySet()) {
            listOfClassProbabilities = (AssociativeArray)entry.getValue();
            Map.Entry<Object, Object> selectedClassEntry = MapMethods.selectMaxKeyValue(listOfClassProbabilities);
            Object theClass = selectedClassEntry.getKey();
            Double previousValue = combinedClassProbabilities.getDouble(theClass);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            combinedClassProbabilities.put(theClass, (Object)(previousValue + 1.0));
        }
        return combinedClassProbabilities;
    }
}

