/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.ensemblelearning;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.algorithms.AbstractBoostingBagging;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.List;
import java.util.Map;

public class Adaboost
extends AbstractBoostingBagging<ModelParameters, TrainingParameters> {
    protected Adaboost(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected Adaboost(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected AbstractBoostingBagging.Status updateObservationAndClassifierWeights(Dataframe validationDataset, AssociativeArray observationWeights) {
        AbstractBoostingBagging.Status status;
        double error = 0.0;
        for (Map.Entry<Integer, Record> e : validationDataset.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            if (r.getY().equals(r.getYPredicted())) continue;
            error += TypeInference.toDouble((Object)observationWeights.get((Object)rId)).doubleValue();
        }
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        int c = modelParameters.getC();
        if (1.0 - error <= 1.0 / (double)c) {
            status = AbstractBoostingBagging.Status.IGNORE;
        } else {
            Double value;
            status = AbstractBoostingBagging.Status.NEXT;
            if (error == 0.0) {
                status = AbstractBoostingBagging.Status.STOP;
                error = 1.0E-8;
            }
            List<Double> weakClassifierWeights = modelParameters.getWeakClassifierWeights();
            double weight = Math.log((1.0 - error) / error) + Math.log((double)c - 1.0);
            weakClassifierWeights.add(weight);
            for (Map.Entry<Integer, Record> e : validationDataset.entries()) {
                Integer rId = e.getKey();
                Record r = e.getValue();
                if (r.getY().equals(r.getYPredicted())) continue;
                value = TypeInference.toDouble((Object)observationWeights.get((Object)rId));
                observationWeights.put((Object)rId, (Object)(value * Math.exp(weight)));
            }
            double normalizer = Descriptives.sum(new FlatDataCollection(observationWeights.values()));
            if (normalizer != 0.0) {
                for (Map.Entry entry : observationWeights.entrySet()) {
                    value = TypeInference.toDouble(entry.getValue());
                    observationWeights.put(entry.getKey(), (Object)(value / normalizer));
                }
            }
        }
        return status;
    }

    public static class TrainingParameters
    extends AbstractBoostingBagging.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractBoostingBagging.AbstractModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

