/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.interfaces;

import com.datumbox.framework.common.concurrency.ConcurrencyConfiguration;
import com.datumbox.framework.common.concurrency.ForkJoinStream;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.interfaces.Parallelizable;
import java.io.Serializable;
import java.util.Map;

public interface PredictParallelizable
extends Parallelizable {
    public Prediction _predictRecord(Record var1);

    default public void _predictDatasetParallel(Dataframe newData, Map<Integer, Prediction> resultsBuffer, ConcurrencyConfiguration concurrencyConfiguration) {
        ForkJoinStream streamExecutor = new ForkJoinStream(concurrencyConfiguration);
        streamExecutor.forEach(StreamMethods.stream(newData.entries(), (boolean)this.isParallelized()), e -> resultsBuffer.put((Integer)e.getKey(), this._predictRecord((Record)e.getValue())));
        streamExecutor.forEach(StreamMethods.stream(newData.entries(), (boolean)this.isParallelized()), e -> {
            Integer rId = (Integer)e.getKey();
            Record r = (Record)e.getValue();
            Prediction p = (Prediction)resultsBuffer.get(rId);
            Record newR = new Record(r.getX(), r.getY(), p.getYPredicted(), p.getYPredictedProbabilities());
            newData._unsafe_set(rId, newR);
        });
    }

    default public void _predictDatasetParallel(Dataframe newData, StorageEngine storageEngine, ConcurrencyConfiguration concurrencyConfiguration) {
        Map resultsBuffer = storageEngine.getBigMap("tmp_resultsBuffer", Integer.class, Prediction.class, StorageEngine.MapType.HASHMAP, StorageEngine.StorageHint.IN_DISK, true, true);
        this._predictDatasetParallel(newData, resultsBuffer, concurrencyConfiguration);
        storageEngine.dropBigMap("tmp_resultsBuffer", resultsBuffer);
    }

    public static class Prediction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object yPredicted;
        private final AssociativeArray yPredictedProbabilities;

        public Prediction(Object yPredicted, AssociativeArray yPredictedProbabilities) {
            this.yPredicted = yPredicted;
            this.yPredictedProbabilities = yPredictedProbabilities;
        }

        public Object getYPredicted() {
            return this.yPredicted;
        }

        public AssociativeArray getYPredictedProbabilities() {
            return this.yPredictedProbabilities;
        }
    }
}

