/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.utilities.SelectKth;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors.AbstractFeatureSelector;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractScoreBasedFeatureSelector<MP extends AbstractModelParameters, TP extends AbstractTrainingParameters>
extends AbstractFeatureSelector<MP, TP> {
    protected AbstractScoreBasedFeatureSelector(TP trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected AbstractScoreBasedFeatureSelector(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _transform(Dataframe newData) {
        Set<Object> selectedFeatures = ((AbstractModelParameters)this.knowledgeBase.getModelParameters()).getFeatureScores().keySet();
        StorageEngine storageEngine = this.knowledgeBase.getStorageEngine();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Map tmp_removedColumns = storageEngine.getBigMap("tmp_removedColumns", Object.class, Boolean.class, StorageEngine.MapType.HASHMAP, StorageEngine.StorageHint.IN_MEMORY, true, true);
        Stream<Object> compatibleColumns = newData.getXDataTypes().entrySet().stream().filter(e -> supportedXDataTypes.contains(e.getValue())).map(e -> e.getKey());
        this.streamExecutor.forEach(StreamMethods.stream(compatibleColumns, (boolean)this.isParallelized()), column -> {
            if (!selectedFeatures.contains(column)) {
                tmp_removedColumns.put(column, true);
            }
        });
        this.logger.debug("Removing Columns");
        newData.dropXColumns(tmp_removedColumns.keySet());
        storageEngine.dropBigMap("tmp_removedColumns", tmp_removedColumns);
    }

    protected void keepTopFeatures(Map<Object, Double> featureScores, int maxFeatures) {
        this.logger.debug("keepTopFeatures()");
        this.logger.debug("Estimating the minPermittedScore");
        Double minPermittedScore = SelectKth.largest(featureScores.values().iterator(), maxFeatures);
        this.logger.debug("Removing features with scores less than threshold");
        Iterator<Map.Entry<Object, Double>> it = featureScores.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Double> entry = it.next();
            if (!(entry.getValue() < minPermittedScore)) continue;
            it.remove();
        }
        int numOfExtraFeatures = featureScores.size() - maxFeatures;
        if (numOfExtraFeatures > 0) {
            this.logger.debug("Removing extra features caused by ties");
            it = featureScores.entrySet().iterator();
            while (it.hasNext() && numOfExtraFeatures > 0) {
                Map.Entry<Object, Double> entry = it.next();
                if (!(entry.getValue() - minPermittedScore <= 0.0)) continue;
                it.remove();
                --numOfExtraFeatures;
            }
        }
    }

    protected void removeRareFeatures(Map<Object, Double> featureCounts, int rareFeatureThreshold) {
        this.logger.debug("removeRareFeatures()");
        Iterator<Map.Entry<Object, Double>> it = featureCounts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Double> entry = it.next();
            if (!(entry.getValue() < (double)rareFeatureThreshold)) continue;
            it.remove();
        }
    }

    public static abstract class AbstractTrainingParameters
    extends AbstractTrainer.AbstractTrainingParameters {
        private Integer rareFeatureThreshold = null;
        private Integer maxFeatures = null;

        public Integer getRareFeatureThreshold() {
            return this.rareFeatureThreshold;
        }

        public void setRareFeatureThreshold(Integer rareFeatureThreshold) {
            this.rareFeatureThreshold = rareFeatureThreshold;
        }

        public Integer getMaxFeatures() {
            return this.maxFeatures;
        }

        public void setMaxFeatures(Integer maxFeatures) {
            this.maxFeatures = maxFeatures;
        }
    }

    public static abstract class AbstractModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Double> featureScores;

        protected AbstractModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Double> getFeatureScores() {
            return this.featureScores;
        }

        protected void setFeatureScores(Map<Object, Double> featureScores) {
            this.featureScores = featureScores;
        }
    }
}

