/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.dataobjects;

import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.common.utilities.RandomGenerator;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.MapRealMatrix;
import com.datumbox.framework.core.common.dataobjects.MapRealVector;
import com.datumbox.framework.core.common.dataobjects.Record;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.linear.OpenMapRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class DataframeMatrix {
    static StorageEngine storageEngine;
    static final AtomicInteger storageId;
    private final RealMatrix X;
    private final RealVector Y;

    public RealMatrix getX() {
        return this.X;
    }

    public RealVector getY() {
        return this.Y;
    }

    private DataframeMatrix(RealMatrix X, RealVector Y) {
        this.Y = Y;
        this.X = X;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setStorageEngine(Dataframe dataset) {
        if (storageEngine != null) return;
        Class<DataframeMatrix> clazz = DataframeMatrix.class;
        synchronized (DataframeMatrix.class) {
            if (storageEngine != null) return;
            String storageName = "mdf" + RandomGenerator.getThreadLocalRandomUnseeded().nextLong();
            storageEngine = dataset.configuration.getStorageConfiguration().createStorageEngine(storageName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static DataframeMatrix newInstance(Dataframe dataset, boolean addConstantColumn, Map<Integer, Integer> recordIdsReference, Map<Object, Integer> featureIdsReference) {
        if (!featureIdsReference.isEmpty()) {
            throw new IllegalArgumentException("The featureIdsReference map should be empty.");
        }
        DataframeMatrix.setStorageEngine(dataset);
        int n = dataset.size();
        int d = dataset.xColumnSize();
        if (addConstantColumn) {
            ++d;
        }
        DataframeMatrix m = new DataframeMatrix((RealMatrix)new MapRealMatrix(n, d), (RealVector)new MapRealVector(n));
        if (dataset.isEmpty()) {
            return m;
        }
        boolean extractY = dataset.getYDataType() == TypeInference.DataType.NUMERICAL;
        int featureId = 0;
        if (addConstantColumn) {
            for (int row = 0; row < n; ++row) {
                m.X.setEntry(row, featureId, 1.0);
            }
            featureIdsReference.put("~CONSTANT", featureId);
            ++featureId;
        }
        int rowId = 0;
        for (Map.Entry<Integer, Record> e : dataset.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            if (recordIdsReference != null) {
                recordIdsReference.put(rId, rowId);
            }
            if (extractY) {
                m.Y.setEntry(rowId, TypeInference.toDouble((Object)r.getY()).doubleValue());
            }
            for (Map.Entry entry : r.getX().entrySet()) {
                Double value;
                Object feature = entry.getKey();
                Integer knownFeatureId = featureIdsReference.get(feature);
                if (knownFeatureId == null) {
                    featureIdsReference.put(feature, featureId);
                    knownFeatureId = featureId;
                    ++featureId;
                }
                if ((value = TypeInference.toDouble(entry.getValue())) == null) continue;
                m.X.setEntry(rowId, knownFeatureId.intValue(), value.doubleValue());
            }
            ++rowId;
        }
        return m;
    }

    public static DataframeMatrix parseDataset(Dataframe newData, Map<Integer, Integer> recordIdsReference, Map<Object, Integer> featureIdsReference) {
        if (featureIdsReference.isEmpty()) {
            throw new IllegalArgumentException("The featureIdsReference map should not be empty.");
        }
        DataframeMatrix.setStorageEngine(newData);
        int n = newData.size();
        int d = featureIdsReference.size();
        DataframeMatrix m = new DataframeMatrix((RealMatrix)new MapRealMatrix(n, d), (RealVector)new MapRealVector(n));
        if (newData.isEmpty()) {
            return m;
        }
        boolean extractY = newData.getYDataType() == TypeInference.DataType.NUMERICAL;
        boolean addConstantColumn = featureIdsReference.containsKey("~CONSTANT");
        int rowId = 0;
        for (Map.Entry<Integer, Record> e : newData.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            if (recordIdsReference != null) {
                recordIdsReference.put(rId, rowId);
            }
            if (extractY) {
                m.Y.setEntry(rowId, TypeInference.toDouble((Object)r.getY()).doubleValue());
            }
            if (addConstantColumn) {
                m.X.setEntry(rowId, 0, 1.0);
            }
            for (Map.Entry entry : r.getX().entrySet()) {
                Integer featureId;
                Object feature = entry.getKey();
                Double value = TypeInference.toDouble(entry.getValue());
                if (value == null || (featureId = featureIdsReference.get(feature)) == null) continue;
                m.X.setEntry(rowId, featureId.intValue(), value.doubleValue());
            }
            ++rowId;
        }
        return m;
    }

    public static RealVector parseRecord(Record r, Map<Object, Integer> featureIdsReference) {
        if (featureIdsReference.isEmpty()) {
            throw new IllegalArgumentException("The featureIdsReference map should not be empty.");
        }
        int d = featureIdsReference.size();
        MapRealVector v = storageEngine != null ? new MapRealVector(d) : new OpenMapRealVector(d);
        boolean addConstantColumn = featureIdsReference.containsKey("~CONSTANT");
        if (addConstantColumn) {
            v.setEntry(0, 1.0);
        }
        for (Map.Entry entry : r.getX().entrySet()) {
            Integer featureId;
            Object feature = entry.getKey();
            Double value = TypeInference.toDouble(entry.getValue());
            if (value == null || (featureId = featureIdsReference.get(feature)) == null) continue;
            v.setEntry(featureId, value);
        }
        return v;
    }

    static {
        storageId = new AtomicInteger();
    }
}

