/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.dataobjects;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.ConcurrencyConfiguration;
import com.datumbox.framework.common.concurrency.ForkJoinStream;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.concurrency.ThreadMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.interfaces.Copyable;
import com.datumbox.framework.common.storage.abstracts.BigMapHolder;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.common.utilities.RandomGenerator;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.common.interfaces.Extractable;
import com.datumbox.framework.core.common.interfaces.Savable;
import com.datumbox.framework.core.common.text.StringCleaner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dataframe
implements Collection<Record>,
Copyable<Dataframe>,
Savable {
    public static final String COLUMN_NAME_Y = "~Y";
    public static final String COLUMN_NAME_CONSTANT = "~CONSTANT";
    private Data data;
    private boolean stored;
    private final StorageEngine storageEngine;
    protected final Configuration configuration;
    private final ForkJoinStream streamExecutor;

    public Dataframe(Configuration configuration) {
        this.configuration = configuration;
        this.storageEngine = this.configuration.getStorageConfiguration().createStorageEngine("dts" + RandomGenerator.getThreadLocalRandomUnseeded().nextLong());
        this.streamExecutor = new ForkJoinStream(this.configuration.getConcurrencyConfiguration());
        this.data = new Data(this.storageEngine);
        this.stored = false;
    }

    private Dataframe(String storageName, Configuration configuration) {
        this.configuration = configuration;
        this.storageEngine = this.configuration.getStorageConfiguration().createStorageEngine(storageName);
        this.streamExecutor = new ForkJoinStream(this.configuration.getConcurrencyConfiguration());
        this.data = (Data)((Object)this.storageEngine.loadObject("data", Data.class));
        this.stored = true;
    }

    private Dataframe(Configuration configuration, TypeInference.DataType yDataType, Map<String, TypeInference.DataType> xDataTypes) {
        this(configuration);
        this.data.yDataType = yDataType;
        this.data.xDataTypes.putAll(xDataTypes);
    }

    @Override
    public void save(String storageName) {
        this.storageEngine.saveObject("data", (Serializable)((Object)this.data));
        this.storageEngine.rename(storageName);
        this.data = (Data)((Object)this.storageEngine.loadObject("data", Data.class));
        this.stored = true;
    }

    @Override
    public void delete() {
        this.storageEngine.clear();
        this._close();
    }

    @Override
    public void close() {
        if (this.stored) {
            this._close();
        } else {
            this.delete();
        }
    }

    private void _close() {
        try {
            this.storageEngine.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.data = null;
        }
    }

    @Override
    public int size() {
        return this.data.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.records.isEmpty();
    }

    @Override
    public void clear() {
        this.data.yDataType = null;
        this.data.atomicNextAvailableRecordId.set(0);
        this.data.xDataTypes.clear();
        this.data.records.clear();
    }

    @Override
    public boolean add(Record r) {
        this.addRecord(r);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.data.records.containsValue((Record)o);
    }

    @Override
    public boolean addAll(Collection<? extends Record> c) {
        c.stream().forEach(r -> this.add((Record)r));
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.records.values().containsAll(c);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (Record r : this.values()) {
            array[i++] = r;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Record r : this.values()) {
            a[i++] = r;
        }
        return a;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.values().iterator();
    }

    @Override
    public Stream<Record> stream() {
        return StreamMethods.stream(this.values(), (boolean)false);
    }

    @Override
    public boolean remove(Object o) {
        Integer id = this.indexOf((Record)o);
        if (id == null) {
            return false;
        }
        this.remove(id);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove((Record)o);
        }
        if (modified) {
            this.recalculateMeta();
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (Map.Entry<Integer, Record> e : this.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            if (c.contains(r)) continue;
            this.remove(rId);
            modified = true;
        }
        if (modified) {
            this.recalculateMeta();
        }
        return modified;
    }

    public Record remove(Integer id) {
        return (Record)this.data.records.remove(id);
    }

    public Integer indexOf(Record o) {
        if (o != null) {
            for (Map.Entry<Integer, Record> e : this.entries()) {
                Integer rId = e.getKey();
                Record r = e.getValue();
                if (!o.equals(r)) continue;
                return rId;
            }
        }
        return null;
    }

    public Record get(Integer id) {
        return (Record)this.data.records.get(id);
    }

    public Integer addRecord(Record r) {
        Integer rId = this._unsafe_add(r);
        this.updateMeta(r);
        return rId;
    }

    public Integer set(Integer rId, Record r) {
        this._unsafe_set(rId, r);
        this.updateMeta(r);
        return rId;
    }

    public int xColumnSize() {
        return this.data.xDataTypes.size();
    }

    public TypeInference.DataType getYDataType() {
        return this.data.yDataType;
    }

    public Map<Object, TypeInference.DataType> getXDataTypes() {
        return Collections.unmodifiableMap(this.data.xDataTypes);
    }

    public FlatDataList getXColumn(Object column) {
        FlatDataList flatDataList = new FlatDataList();
        for (Record r : this.values()) {
            flatDataList.add(r.getX().get(column));
        }
        return flatDataList;
    }

    public FlatDataList getYColumn() {
        FlatDataList flatDataList = new FlatDataList();
        for (Record r : this.values()) {
            flatDataList.add(r.getY());
        }
        return flatDataList;
    }

    public void dropXColumns(Set<Object> columnSet) {
        columnSet.retainAll(this.data.xDataTypes.keySet());
        if (columnSet.isEmpty()) {
            return;
        }
        this.data.xDataTypes.keySet().removeAll(columnSet);
        this.streamExecutor.forEach(StreamMethods.stream(this.entries(), (boolean)true), e -> {
            Integer rId = (Integer)e.getKey();
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            boolean modified = xData.keySet().removeAll(columnSet);
            if (modified) {
                Record newR = new Record(xData, r.getY(), r.getYPredicted(), r.getYPredictedProbabilities());
                this._unsafe_set(rId, newR);
            }
        });
    }

    public Dataframe getSubset(FlatDataList idsCollection) {
        Dataframe d = new Dataframe(this.configuration);
        for (Object id : idsCollection) {
            d.add(this.get((Integer)id));
        }
        return d;
    }

    public void recalculateMeta() {
        this.data.yDataType = null;
        this.data.xDataTypes.clear();
        for (Record r : this.values()) {
            this.updateMeta(r);
        }
    }

    public Dataframe copy() {
        Dataframe d = new Dataframe(this.configuration);
        for (Map.Entry<Integer, Record> e : this.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            d.set(rId, r);
        }
        return d;
    }

    public Iterable<Map.Entry<Integer, Record>> entries() {
        return () -> new Iterator<Map.Entry<Integer, Record>>(){
            private final Iterator it;
            {
                this.it = Dataframe.this.data.records.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Map.Entry<Integer, Record> next() {
                return (Map.Entry)this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is a read-only iterator, remove operation is not supported.");
            }
        };
    }

    public Iterable<Integer> index() {
        return () -> new Iterator<Integer>(){
            private final Iterator it;
            {
                this.it = Dataframe.this.data.records.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Integer next() {
                return (Integer)this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is a read-only iterator, remove operation is not supported.");
            }
        };
    }

    public Iterable<Record> values() {
        return () -> new Iterator<Record>(){
            private final Iterator it;
            {
                this.it = Dataframe.this.data.records.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Record next() {
                return (Record)this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is a read-only iterator, remove operation is not supported.");
            }
        };
    }

    public Record _unsafe_set(Integer rId, Record r) {
        this.data.atomicNextAvailableRecordId.updateAndGet(x -> x < rId ? Math.max(x + 1, rId + 1) : x);
        return this.data.records.put(rId, r);
    }

    private Integer _unsafe_add(Record r) {
        Integer newId = this.data.atomicNextAvailableRecordId.getAndIncrement();
        this.data.records.put(newId, r);
        return newId;
    }

    private void updateMeta(Record r) {
        Object value;
        for (Map.Entry entry : r.getX().entrySet()) {
            Object column = entry.getKey();
            Object value2 = entry.getValue();
            if (value2 == null) continue;
            this.data.xDataTypes.putIfAbsent(column, TypeInference.getDataType(value2));
        }
        if (this.data.yDataType == null && (value = r.getY()) != null) {
            this.data.yDataType = TypeInference.getDataType((Object)r.getY());
        }
    }

    private static class Data
    extends BigMapHolder {
        private TypeInference.DataType yDataType = null;
        private AtomicInteger atomicNextAvailableRecordId = new AtomicInteger();
        @BigMap(keyClass=Object.class, valueClass=TypeInference.DataType.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, TypeInference.DataType> xDataTypes;
        @BigMap(keyClass=Integer.class, valueClass=Record.class, mapType=StorageEngine.MapType.TREEMAP, storageHint=StorageEngine.StorageHint.IN_DISK, concurrent=true)
        private Map<Integer, Record> records;

        private Data(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }

    public static class Builder {
        public static Dataframe parseTextFiles(Map<Object, URI> textFilesMap, Extractable textExtractor, Configuration configuration) {
            Dataframe dataset = new Dataframe(configuration);
            Logger logger = LoggerFactory.getLogger(Builder.class);
            for (Map.Entry<Object, URI> entry : textFilesMap.entrySet()) {
                Object theClass = entry.getKey();
                URI datasetURI = entry.getValue();
                logger.info("Dataset Parsing {} class", theClass);
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(datasetURI)), "UTF8"));){
                    int baseCounter = dataset.size();
                    ThreadMethods.throttledExecution((Stream)StreamMethods.enumerate(br.lines()), e -> {
                        Integer rId = baseCounter + (Integer)e.getKey();
                        String line = (String)e.getValue();
                        AssociativeArray xData = new AssociativeArray(textExtractor.extract(StringCleaner.clear(line)));
                        Record r = new Record(xData, theClass);
                        dataset.set(rId, r);
                    }, (ConcurrencyConfiguration)configuration.getConcurrencyConfiguration());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return dataset;
        }

        public static Dataframe parseCSVFile(Reader reader, String yVariable, LinkedHashMap<String, TypeInference.DataType> headerDataTypes, char delimiter, char quote, String recordSeparator, Long skip, Long limit, Configuration configuration) {
            Logger logger = LoggerFactory.getLogger(Builder.class);
            if (skip == null) {
                skip = 0L;
            }
            if (limit == null) {
                limit = Long.MAX_VALUE;
            }
            logger.info("Parsing CSV file");
            if (!headerDataTypes.containsKey(yVariable)) {
                logger.warn("WARNING: The file is missing the response variable column {}.", (Object)yVariable);
            }
            TypeInference.DataType yDataType = headerDataTypes.get(yVariable);
            HashMap<String, TypeInference.DataType> xDataTypes = new HashMap<String, TypeInference.DataType>(headerDataTypes);
            xDataTypes.remove(yVariable);
            Dataframe dataset = new Dataframe(configuration, yDataType, xDataTypes);
            CSVFormat format = CSVFormat.RFC4180.withHeader(new String[0]).withDelimiter(delimiter).withQuote(quote).withRecordSeparator(recordSeparator);
            try (CSVParser parser = new CSVParser(reader, format);){
                ThreadMethods.throttledExecution(StreamMethods.enumerate((Stream)StreamMethods.stream((Spliterator)parser.spliterator(), (boolean)false)).skip(skip).limit(limit), e -> {
                    Integer rId = (Integer)e.getKey();
                    CSVRecord row = (CSVRecord)e.getValue();
                    if (!row.isConsistent()) {
                        logger.warn("WARNING: Skipping row {} because its size does not match the header size.", (Object)row.getRecordNumber());
                    } else {
                        Object y = null;
                        AssociativeArray xData = new AssociativeArray();
                        for (Map.Entry entry : headerDataTypes.entrySet()) {
                            String column = (String)entry.getKey();
                            TypeInference.DataType dataType = (TypeInference.DataType)entry.getValue();
                            Object value = TypeInference.DataType.parse((String)row.get(column), (TypeInference.DataType)dataType);
                            if (yVariable != null && yVariable.equals(column)) {
                                y = value;
                                continue;
                            }
                            xData.put((Object)column, value);
                        }
                        Record r = new Record(xData, y);
                        dataset._unsafe_set(rId, r);
                    }
                }, (ConcurrencyConfiguration)configuration.getConcurrencyConfiguration());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return dataset;
        }

        public static Dataframe load(String storageName, Configuration configuration) {
            return new Dataframe(storageName, configuration);
        }
    }
}

