package xww.io

import java.io.{InputStreamReader, FileReader, FileWriter, PrintWriter}


/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 3/26/12
 * Time: 5:53 PM
 * To change this template use File | Settings | File Templates.
 */


object xwwfile {

  def outputToFile(fileName:String, writerAction:PrintWriter => Unit) {
    using(new PrintWriter(fileName)){ pw =>
      writerAction(pw)
    }
  }

  def outputToFile(fileName: String, data: String) {
    outputToFile(fileName, pw => pw.print(data))
  }

  def outputToWriter(writer:PrintWriter, writerAction: PrintWriter=> Unit ){
    using(writer) { w =>
      writerAction(w)
    }
  }

  def appendToFile(fileName: String, textData: String) =
    using(new FileWriter(fileName, true)) {
      fileWriter => using(new PrintWriter(fileWriter)) {
        printWriter => printWriter.println(textData)
      }
    }

  def getLines(fileName:String) =
    try{
    io.Source.fromFile(fileName).getLines()
  }
  catch {
    case e:java.io.FileNotFoundException => throw new Error("File path [%s] not found.".format(fileName), e)
    case e:Exception => throw new Error("Error when reading file %s".format(fileName), e)
  }
  def getNonEmptyLines(fileName:String) = getLines(fileName).map(_.trim).filter(line=> line.length>0)
  def getNonEmptyLines(lines:Iterator[String]) = lines.map(_.trim).filter(line=> line.length>0)
  def getNonEmptyAndNonCommentLines(fileName:String) = getLines(fileName).map(_.trim).filter(line=> line.length>0 && line.head != '#')
  def getNonEmptyAndNonCommentLines(lines:Iterator[String]) = lines.map(_.trim).filter(line=> line.length>0 && line.head != '#')

}
