package xww.cmd

/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 3/26/12
 * Time: 6:33 PM
 * To change this template use File | Settings | File Templates.
 */

object parser{
  def splitArguments(line: String, seps: Array[Char] = Array(' ', '\t'), quotes: Array[Char] = Array('\'', '"')) = {
    var args: List[String] = List()
    var inquot = false
    val sb = new StringBuilder
    for (ch <- line) {
      if (seps.contains(ch)) {
        if (!sb.isEmpty && !inquot) {
          args ::= sb.toString;
          sb.clear
        }
        if (inquot) sb.append(ch)
      }
      else if (quotes.contains(ch)) inquot = !inquot
      else sb.append(ch)
    }
    if (!sb.isEmpty) args ::= sb.toString
    args.reverse.toArray
  }

  def checkIfDuplicate(keys:List[String]): Unit = {
    val sl = keys.sortWith(_ < _)
    var previous: String = null
    for (i <- sl) {
      if (previous == i) {
        throw new OptionKeyDuplicationException(i)
      } else {
        previous = i
      }
    }
  }
}

trait parserUnit {
  def parse(input: String): Unit
  def parsedString:String
  val alias: List[String]
  val description: String
  val required: Boolean
  val consumeNext: Boolean

  def Visited: Boolean
  def checkLegal(){
    if (required && !Visited) throw new OptionMissingException(this)
  }
}
