package xww.cmd

/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 2/29/12
 * Time: 4:08 PM
 * To change this template use File | Settings | File Templates.
 */


abstract class Opt[T](val alias: List[String], val required: Boolean = false, val description: String = "", val valueCheck: Option[T => Boolean] = None, val valueCheckInfo: String = "Value %s is invalid") extends parserUnit {
  protected var value: T = _
  val defaultValue: T
  //holding the default value
  protected var _parsedString = ""

  def parsedString: String = _parsedString

  def this() {
    this(Nil, false)
  }

  lazy val Value = {
    if (Visited) value
    else if (!required) defaultValue
    else throw new RuntimeException(alias.head + " is not provided") //should never reach this line
  }

  val consumeNext = true
  private[this] var visited = false

  def Visited = visited

  def parse(input: String): Unit = {
    try {
      value = internalParse(input)
      _parsedString = input
    }
    catch {
      case ex: Exception =>
        println("Option [%s] format error.".format(alias.mkString(",")))
        throw ex
    }
    visited = true
  }

  override def checkLegal() {
    super.checkLegal()
    //    if (valueCheck.isDefined && Visited && !valueCheck.get(Value)) throw new OptionValueIllegalException(Value, valueCheckInfo, optionName)
    if (valueCheck.isDefined && !valueCheck.get(Value)) throw new OptionValueIllegalException(Value, valueCheckInfo, optionName)
  }


  protected def internalParse(input: String): T

  private def optionName = alias.mkString("[", ", ", "]")

  //  override def toString = "%s\t[%s]\t%s\tdefault value: [%s]".format(if (required) "*" else "", alias.mkString(", "), description, defaultValue)
  override def toString = {
    if (required) s"*\t$optionName\t$description"
    else s"\t$optionName\t$description\t| default: [$defaultValue]"
  }
}


class IntOpt(override val alias: List[String], override val required: Boolean, override val description: String = "", override val valueCheck: Option[Int => Boolean] = None, override val valueCheckInfo: String = "", override val defaultValue: Int = 0)
  extends Opt[Int] {
  def internalParse(input: String) = input.toInt
}

class DoubleOpt(override val alias: List[String], override val required: Boolean, override val description: String = "", override val valueCheck: Option[Double => Boolean] = None, override val valueCheckInfo: String = "", override val defaultValue: Double = 0.0)
  extends Opt[Double] {
  def internalParse(input: String) = input.toDouble
}

class BoolOpt(override val alias: List[String], override val description: String = "")
  extends Opt[Boolean] {
  override val defaultValue = false
  value = false
  override val consumeNext = false

  def internalParse(input: String) = true
}

class StrOpt(override val alias: List[String], override val required: Boolean, override val description: String = "", override val valueCheck: Option[String => Boolean] = None, override val valueCheckInfo: String = "", override val defaultValue: String = "")
  extends Opt[String] {
  protected def internalParse(input: String) = input
}

class StrRegexMatcher(input:String) extends (String => Boolean){
  private def nullOrEmpty(s:String) = (s == null || s.isEmpty)
  private val innerFunc:(String => Boolean) = {
    if(nullOrEmpty(input))
      _ => true
    else
      input.r.findFirstMatchIn(_).isDefined
  }
  def apply(v1: String) = innerFunc(v1)
  override def toString = {
    if(nullOrEmpty(input)) "match any input string"
    else s"match the regex [$input]"
  }
}

object AllMatcher extends StrRegexMatcher("")

class StrRegexMatchOpt(override val alias: List[String], override val required: Boolean, override val description: String = "", override val defaultValue: String => Boolean = AllMatcher)
  extends Opt[String => Boolean] {
  protected def internalParse(input: String) = new StrRegexMatcher(input)
}


class EnumOpt(override val alias: List[String], override val required: Boolean, val choices: Array[String], override val description: String = "",
              override val valueCheck: Option[String => Boolean], override val valueCheckInfo: String,
              override val defaultValue: String)
//              override val valueCheck: Option[String => Boolean] = Some(x => choices.contains(x)), override val valueCheckInfo: String = "%s is not one of " + choices.mkString("|"),
//              override val defaultValue: String = "")
  extends Opt[String] {
  def this(alias: List[String], choices: Array[String], description: String = "", required: Boolean = true, defaultValue: String = "") {
    this(alias, required, choices, description, Some(x => choices.contains(x)), "%s is not one of " + choices.mkString("|"), "")
  }

  protected def internalParse(input: String) = input
}

class IntRangeOpt(override val alias: List[String], override val required: Boolean, override val description: String = "",
                  override val valueCheck: Option[IntRange => Boolean] = None, override val valueCheckInfo: String = "%s is not a legal range",
                  override val defaultValue: IntRange = new IntRange(":"))
  extends Opt[IntRange] {
  protected def internalParse(input: String) = new IntRange(input)
}

class DoubleRangeOpt(override val alias: List[String], override val required: Boolean, override val description: String = "",
                     override val valueCheck: Option[DoubleRange => Boolean] = None, override val valueCheckInfo: String = "%s is not a legal range",
                     override val defaultValue: DoubleRange = new DoubleRange(":"))
  extends Opt[DoubleRange] {
  protected def internalParse(input: String) = new DoubleRange(input)
}

import Ordering.Implicits._

class NumberRange[T: Ordering](input: String, convertFunc: String => T) {
  def convertToT(s: String) = if (s == "") None else Some(convertFunc(s))

  val (min, max) = {
    val i = input.indexOf(':')
    (convertToT(input.substring(0, i)), convertToT(input.substring(i + 1)))
  }
  val notDefined = min.isEmpty && max.isEmpty
  val withinRange: T => Boolean = (min, max) match {
    case (None, None) => (_) => true
    case (Some(minV), None) => _ >= minV
    case (None, Some(maxV)) => _ <= maxV
    case (Some(minV), Some(maxV)) => (x => x >= minV && x <= maxV)
  }

  def allWithinRange(args: T*) = args.forall(withinRange)

  def comformTo(standard: NumberRange[T]) = {
    (this.min.isEmpty || standard.min.isEmpty || this.min.get >= standard.min.get) &&
      (this.max.isEmpty || standard.max.isEmpty || this.max.get <= standard.max.get)
  }

  override def toString = {
    if(min.isDefined || max.isDefined)
      "%s:%s".format(min.getOrElse(""), max.getOrElse(""))
    else
      "unlimited range"
  }
}

class IntRange(input: String) extends NumberRange[Int](input, _.toInt) {
  //min:start_index, max:end_index_excluded
  val stringRangeFunc: String => String = (min, max) match {
    case (None, None) => (x => x)
    case (Some(minV), None) => {
      x: String => if (minV >= 0) x.substring(minV) else x.substring(x.length + minV)
    }
    case (None, Some(maxV)) => {
      x: String => if (maxV >= 0) x.substring(0, maxV) else x.substring(0, x.length + maxV)
    }
    case (Some(minV), Some(maxV)) if (minV >= 0 && maxV >= minV) => (x => x.substring(minV, maxV))
    case (Some(minV), Some(maxV)) if (maxV < 0 && maxV >= minV) => (x => x.substring(x.length + minV, x.length + maxV))
    case _ => x => ""
  }
}

class DoubleRange(input: String) extends NumberRange[Double](input, _.toDouble)