package xww.cmd

/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 3/26/12
 * Time: 6:35 PM
 * To change this template use File | Settings | File Templates.
 */


class OptionMissingException(o: parserUnit) extends RuntimeException("Error: Option [%s] missing.".format(o.toString))
class OptionKeyNotFoundException(key:String) extends RuntimeException("Key %s not found in registered options".format(key))
class OptionUnknownException(o:String) extends RuntimeException("Unknown option %s found.".format(o))

class OptionValueIllegalException[T](value:T, info: String, typeInfo:String) extends RuntimeException(typeInfo + "  " + info.format(value))

class OptionKeyDuplicationException(key: String, info: String = "") extends RuntimeException(info) {
  override def toString = "OptionKeyDuplicationError, Key: %s %s".format(key, info)
}