package xww.cmd

import java.io.PrintWriter

/**
 * Created with IntelliJ IDEA.
 * User: xiongwe
 * Date: 7/25/12
 * Time: 10:38 AM
 * To change this template use File | Settings | File Templates.
 */


class FileInputPathOpt(override val alias: List[String], override val required: Boolean, override val description: String = "",
                       override val valueCheck: Option[String => Boolean] = Some(x => x.isEmpty || new java.io.File(x).exists()),
                       override val valueCheckInfo: String = "File path [%s] doesn't exit.", override val defaultValue: String = "")
  extends Opt[String] {
  protected def internalParse(input: String) = new java.io.File(input).getAbsolutePath
  override def toString = super.toString + "\t[must be a valid file path]"
}
class FileOrStdInputOpt(override val alias: List[String], override val description: String = "",
                        override val defaultValue:io.BufferedSource = xww.io.StdinBuffer)
  extends Opt[io.BufferedSource] {
  protected def internalParse(input: String) = {
    if (! new java.io.File(input).exists() ) throw new java.io.FileNotFoundException(input)
    io.Source.fromFile(input)
  }
}
class FileOrStdOutOpt(override val alias: List[String], override val description: String = "",
                      override val defaultValue:PrintWriter = xww.io.StdoutWriter)
  extends Opt[PrintWriter] {
  protected def internalParse(input: String) = {
    new PrintWriter(input)
  }
}

class DirecotryPathOpt(override val alias: List[String], override val required: Boolean, override val description: String = "",
                       override val valueCheck: Option[String => Boolean] = Some(x => new java.io.File(x).isDirectory), override val valueCheckInfo: String = "Path '%s' is not a valid directory.", override val defaultValue: String = System.getProperty("user.dir"))
  extends Opt[String] {
  protected def internalParse(input: String) = input
}
