package xww.cmd

import scala.collection.mutable.ArrayBuffer

/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 3/26/12
 * Time: 6:32 PM
 * To change this template use File | Settings | File Templates.
 */

class CommandLineWithMultiplePrograms(val description: String, protected val nameFuncs: (String, String, Array[String] => Unit)*) {
  parser.checkIfDuplicate(nameFuncs.map(_._1).toList)

  def Run(argLine: String): Unit = {
    val args = parser.splitArguments(argLine)
    Run(args)
  }

  def Run(args: Array[String]): Unit = {
    if (args.isEmpty) {
      Help();
      return
    }
    val f = nameFuncs.find(_._1 == args.head)
    //      .getOrElse(throw new OptionKeyNotFoundException(args.head))
    if (f.isEmpty) {
      println("'%s' is not a valid command".format(args.head))
      Help()
    } else {
      f.get._3(args.tail)
    }
  }

  def Help() = {
    println(description)
    println()
    println("<command name> [options]")
    println()
    println("Commands:")
    nameFuncs.foreach(o => println("  %-10s %s ".format(o._1, o._2)))
  }
}

abstract class RunnableEntity() extends CommandlineRunnable {
  val name: String
  val description: String
}

trait CommandlineRunnable {
  def run(args: Array[String])

  def runWholeLine(commandLine: String) {
    run(parser.splitArguments(commandLine))
  }
}


class CompositeProgram(val name: String, val description: String, protected val nameFuncs: List[RunnableEntity])
  extends RunnableEntity {

  def this(name: String, description: String, nameFuncs: RunnableEntity*) = this(name, description, nameFuncs.toList)

  parser.checkIfDuplicate(nameFuncs.map(_.name))

  def run(args: Array[String]): Unit = {
    if (args.isEmpty) {
      Help()
    }
    else {
      val f = nameFuncs.find(_.name == args.head)
      if (f.isEmpty) {
        println("'%s' is not a valid command".format(args.head))
        Help()
      } else {
        f.get.run(args.tail)
      }
    }
  }

  protected def Help() = {
    println(name)
    println(description)
    println()
    println("<command name> [options]")
    println()
    println("Commands:")
    nameFuncs.foreach(o => println("  %-10s %s ".format(o.name, o.description)))
  }
}


abstract class SingleProgram extends RunnableEntity {

  def runCoreLogic(): Unit

  def run(args: Array[String]): Unit = {
    try {
      if (args.exists(helpOpt.alias.contains(_))) {
        help()
      }
      else {
        parse(args)
        try {
          runCoreLogic()
        }
        catch {
          case ex: Exception => println("%s\t%s\t%s".format(ex.getClass, ex.getMessage, ex.getStackTraceString))
        }
      }
    }
    catch {
      case ex: Exception =>
        println("[ERROR]: %s\n%s\n\n%s\n".format(ex.getClass, ex.getMessage, ex.getStackTraceString))
        help()
    }
  }

  /**
   * old stuff
   */

  protected val options: List[parserUnit]
  protected var remains: Array[String] = _


  def isKey(item: String) = List('-', '/').contains(item(0))

  def findOption(key: String) = options.find(_.alias.contains(key))

  val helpOpt = new BoolOpt(List("-h", "-help", "/h", "/help", "--help"), "Show help information")


  /** *
    * Parse arguments from String array
    * @param strs
    */
  def parse(strs: Array[String]): Unit = {
    parser.checkIfDuplicate(options.toList.flatMap(x => x.alias))
    var lst: List[String] = List()
    val iter = strs.iterator
    while (iter.hasNext) {
      val currentItem = iter.next()
      if (!isKey(currentItem)) lst ::= currentItem
      else {
        val opt = findOption(currentItem).getOrElse(throw new OptionUnknownException(currentItem))
        if (opt.consumeNext) {
          if (iter.hasNext) opt.parse(iter.next())
          else throw new RuntimeException("Not enough argument for option: " + opt.alias.mkString(" "))
        }
        else opt.parse("") // only for bool options
      }
    }
    options.foreach(_.checkLegal)
    remains = lst.reverse.toArray
  }


  def help() {
    println(
      s"""$name : $description

    * Options are mandatory
      """)
    options.foreach(println)
  }

}