package xww.cmd

import collection.mutable.ArrayBuffer

/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 2/27/12
 * Time: 10:55 PM
 * To change this template use File | Settings | File Templates.
 */

//type nameFunc = Tuple2[String, Array[String] => Unit]

class CommandLineParser(val description: String = "") {
  private val options: ArrayBuffer[parserUnit] = new ArrayBuffer()
  private[this] var remains: Array[String] = _

  def remainningArgs: Array[String] = remains

  def addOption(o: parserUnit):Unit = options.append(o)

  def addOptions(o: parserUnit*): Unit = options.appendAll(o)

  var isKey = (item: String) => List('-', '/').contains(item(0))

  def findOption(key: String) = options.find(_.alias.contains(key))

  val helpOpt = new BoolOpt(List("-h", "-help", "/h", "/help", "--help"), "Show help information")

  def addHelpOption: Unit = addOption(helpOpt)


  def tryParseThen(strs: Array[String], workThen:  => Unit): Boolean = {
    try {
      if (strs.exists(helpOpt.alias.contains(_))) { help(); false }
      else { parse(strs); workThen;  true }
    } catch {
      case ex: Exception => println("[Command line ERROR] :(" + ex.getMessage + "\n" + ex.toString + "\n")
        throw ex
        false
    }
  }

  def tryParseThen(str: String, workThen: => Unit): Boolean = {
    tryParseThen(parser.splitArguments(str), workThen)
  }
  def tryParse(str: String) = {
    tryParseThen(parser.splitArguments(str), ())
  }
  def tryParse(strs: Array[String]) = {
    tryParseThen(strs, ())
  }

  /***
   * Parse arguments from String array
   * @param strs
   */
  def parse(strs: Array[String]): Unit = {
    parser.checkIfDuplicate(options.toList.flatMap(x => x.alias))
    var lst: List[String] = List()
    val iter = strs.iterator
    while (iter.hasNext) {
      val currentItem = iter.next()
      if (!isKey(currentItem)) lst ::= currentItem
      else {
        val opt = findOption(currentItem).getOrElse( throw new OptionUnknownException(currentItem) )
        if (opt.consumeNext) {
          if (iter.hasNext) opt.parse(iter.next())
          else throw new RuntimeException("Not enough argument for option: " + opt.alias.mkString(" "))
        }
        else opt.parse("") // only for bool options
      }
    }
    options.foreach(_.checkLegal)
    //    val misso = options.find(o => o.required && !o.Visited)
    //    if (!misso.isEmpty)
    //      throw new OptionMissingException(misso.get)
    remains = lst.reverse.toArray
  }

  /***
   *
   * @param str
   */
  def parse(str: String): Unit = {
    parse(parser.splitArguments(str))
  }

  def help() {
    println(
      """%s

    * Options are mandatory
""".format(description))
    options.foreach(println)
  }
}
