package xww

import java.io.PrintWriter

/**
 * Created with IntelliJ IDEA.
 * User: WenweiXiong
 * Date: 7/9/13
 * Time: 7:50 PM
 */
object SharedFuncs {

  def now = new java.util.Date()

  val separatorLine = "-" * 80
  val defaultWriter = new PrintWriter(Console.out, true)

  def logException(exception:Exception){
    Console.err.println(s"Error occurred on $now\n" + separatorLine + s"\n${exception.getClass}\n${exception.getMessage}\n${exception.getStackTraceString}")
  }

  def logError(errTitle:String = "", errMsg:String) {
    if(errTitle.nonEmpty){
      Console.err.println(s"$errTitle [ERROR at $now ]")
    }
    Console.err.println(separatorLine)
    Console.err.println(errMsg)
  }

  def log(info:String, withTime:Boolean = true, writer:java.io.PrintWriter = defaultWriter, forceFlush:Boolean = false){
    writer.println(s"$info    [$now]")
    if(forceFlush)
      writer.flush()
  }

  def logProcess[T](f: =>T, info:String, withTime:Boolean = true, writer:java.io.PrintWriter = defaultWriter) = {
    writer.print(s"$info    [$now] ......")
    writer.flush()
    val res = f
    writer.println(s"OK    [$now]")
    res
  }


}
