package xww.LCV

import util.matching.Regex
import java.util.regex.Pattern

/**
 * Created with IntelliJ IDEA.
 * User: xiongwe
 * Date: 9/11/12
 * Time: 12:00 PM
 * To change this template use File | Settings | File Templates.
 */
class RelativeLCV(chars: Array[Char], locations: Array[Int], _supportNo:Int = 0, val pattern: Pattern = null) extends LCV(chars, locations, _supportNo) {

  def this(char: Char, location: Int) {
    this(Array(char), Array(location))
  }

  private val dotString = toDotPatternString()

  override def matchSeq(seq: String):Boolean = pattern.matcher(seq).find() //r.findFirstIn(seq).nonEmpty

  // Get count of all matches in one sequence
  def countInSeq(seq: String) = {
    var i = 0
    val matcher = pattern.matcher(seq)
    while(matcher.find())
      i += 1
    i
  }
  // matching count of seqs (multiple matching in one seq allowed)
  def getSupportNumberMultiple(seqs: Traversable[String]) = seqs.foldLeft(0)(_ + countInSeq(_))
  def updateSupportNumberMultiple(seqs: Traversable[String]) = {
    supportNo = getSupportNumberMultiple(seqs); supportNo
  }

  override def toRegexVersion() = {
    val regexS =  Pattern.compile("%1$s(?=%2$s)".format(dotString.head, dotString.substring(1)))
//    val regexS =  "%1$s(?=%2$s)".format(dotString.head, dotString.substring(1)).r
    new RelativeLCV(chars, locations,supportNo, regexS)
  }

  override def equals(other: Any) = {
    val that = other.asInstanceOf[RelativeLCV]
    if (that == null) false
    else this.dotString == that.dotString
  }

  override def hashCode() = dotString.hashCode
}
