package xww.LCV

import util.matching.Regex
import java.lang.StringBuffer

/**
 * Created by IntelliJ IDEA.
 * User: xiongwe
 * Date: 3/20/12
 * Time: 6:08 PM
 * To change this template use File | Settings | File Templates.
 */
/*
param locations 1-based index
 */
class LCV(private val chars:Array[Char], private val locations:Array[Int], var supportNo:Int = 0, val r:Regex = null){

  def this(char:Char, location:Int) { this(Array(char), Array(location)) }

//  var supportNo:Int = _
  var supportNo2:Option[Int] = _
  val length = chars.length
  def init:List[AnyVal] = (locations.init ++ chars.init).toList
  def tail(resetLocations:Boolean = false):List[AnyVal] = {
    if(resetLocations){
      val secondLoc = locations.tail.head - 1
      (locations.tail.map(_ - secondLoc) ++ chars.tail).toList
    }
    else
      (locations.tail ++ chars.tail).toList
  }
  def firstLocation = locations.head
  def lastLocation = locations.last
  def lastChar = chars.last
  def firstChar = chars.head
  def offsetLocation(offset:Int) { (0 until locations.length).foreach(locations(_) += offset) }
  // LCV match sequence
  def matchSeq(seq:String):Boolean = locations.zip(chars).forall(i => seq(i._1 - 1) == i._2)
  // how many seqs matching LCV pattern
  def getSupportNumber(seqs:Traversable[String]) = seqs.count(matchSeq)
  def updateSupportNumber(seqs:Traversable[String]) = { supportNo = getSupportNumber(seqs); supportNo}
  override def toString() = chars.zip(locations).map(x => x._1 + x._2.toString).mkString(" ") + "," + supportNo.toString
//  def toDotPatternString(sep:String) = chars.head.toString + chars.tail.zip( locations.tail.zip(locations).map( p => p._1 - p._2 - 1 ) ).map( p => sep * p._2 + p._1.toString).mkString
  def toDotPatternString(sep:String):String = {
    val res = new StringBuffer()
    res.append(firstChar)
    var lastIndex = firstLocation
    for (i <- 1 until length){
      val offset = locations(i) - lastIndex - 1 // how many sep chars should be added
      res.append(sep * offset + chars(i))
      lastIndex = locations(i)
    }
    res.toString
  }

  def toDotPatternString():String = toDotPatternString(".")

  def toRegexVersion() = {
    val dot = toDotPatternString()
    val regexS = "%1$s(?=%2$s)".format(dot.head, dot.substring(1)).r
    val res = new LCV(chars, locations, supportNo, regexS)
    res.supportNo = supportNo
    res
  }
  def toRelativeVersion() = new RelativeLCV(chars, locations, supportNo)

  override def equals(other: Any) = {
    val that = other.asInstanceOf[LCV]
    if (that == null) false
    else  this.locations.sameElements(that.locations) && this.chars.sameElements(that.chars)
  }

//  override def hashCode() = locations.mkString.hashCode * 17 + chars.mkString.hashCode * 11
}

object LCV{
  private def checkArgs(chars:Array[Char], locations:Array[Int]) {
    if (chars == null || locations == null) throw new LCVCreateException("chars or locations null reference.")
    if (chars.length != locations.length) throw new LCVCreateException("Length unequal error of chars and locations.")
  }
  def apply(chars:Array[Char], locations:Array[Int]) = {
    checkArgs(chars, locations)
    new LCV(chars, locations)
  }
  def apply(input:String) = fromStringOld(input)
  // combine two LCVs of length-N, left N-1 part should be the same, then combine the rest different parts.
  def combine(left:LCV, right:LCV) = apply(left.chars :+ right.lastChar, left.locations :+ right.lastLocation)
  def combineRelative(left:RelativeLCV, right:RelativeLCV) = new RelativeLCV(left.chars :+ right.lastChar, left.locations :+ right.lastLocation)

  def combineRelativeOffset(left:RelativeLCV, right:RelativeLCV, offset:Int) = new RelativeLCV(left.chars :+ right.lastChar, left.locations :+ (right.lastLocation + offset))

  def combineRelativeOffsetAuto(tail:RelativeLCV, init:RelativeLCV) = {
    val offset = tail.locations(1) - tail.firstLocation
    combineRelativeOffset(tail, init, offset)
  }


  def fromStringOld(input:String):LCV = {
    val parts = input.split(",")
    val lcvStrs = parts.head.split(""" +""").filterNot(_.isEmpty).toArray
    val lcv = apply(lcvStrs.map(_.head), lcvStrs.map(_.tail.toInt))
    if (parts.length > 1) lcv.supportNo = parts(1).toInt
    if (parts.length > 2) lcv.supportNo2 = Some(parts(2).toInt)
    lcv
  }
  def fromStringsOld(lines:Iterator[String]):Iterator[LCV] = lines.map(_.trim).filterNot(x => x.isEmpty || x.head == '#').map(fromStringOld)
  def fromFileOld(filePath:String):Iterator[LCV] = fromStringsOld(io.Source.fromFile(filePath).getLines())
}
