library(ggplot2)
library(dplyr)
library(data.table)

data <- fread("X_hom_added.txt");head(data)

d <- melt(data)
colnames(d) <- c("Chromosome","Species","gene")

ggplot(d,aes(x=Species,y=gene,fill=Chromosome))+
  geom_col(position = "fill", width = 0.6)+ylab("Gene ratio")+
  theme(axis.text.x = element_text(angle = 45, hjust = 0.5, vjust = 0.5))


ggsave("hom_X-1.pdf",width=12,height=8)
ggsave("hom_X-1.png",width=8,height=6)




# Horizontal barplot with coord_flip()
ggplot(d,aes(x=Species,y=gene,fill=Chromosome))+
  geom_col(position = "fill", width = 0.6)+ylab("gene ratio") +
  coord_flip()
ggsave("hom_X_horizon.jpg",width=12,height=8)
