library(ggplot2)
a <- read.table("Lmig_Sat_density.txt")
head(a)
colnames(a) <- c("Chr","position","position2","density")
head(a)
p <- ggplot(a,aes(x=position,y=density))+geom_line()
p + facet_grid(Chr~.,scales = "free_y")+
  ylab("Satellite density")+theme_bw()+
  theme(axis.text=element_text(size=12),
        axis.title.x=element_text(size=14),
        axis.title.y=element_text(size=14),
        legend.text=element_text(size=14),
        legend.title=element_text(size=14))


ggsave("Lmig_Sat_density.pdf",width=10,height=8)
