library(tidyverse)
library(stringr)
library(KEGGREST)
library(AnnotationForge)
library(clusterProfiler)
library(jsonlite)
library(purrr)
library(RCurl)

options(stringsAsFactors = F)

emapper <- read.table("Lmig.emapper.annt",header=TRUE,sep="\t")
emapper[emapper==""] <- NA

gene_info <- emapper %>% 
  dplyr::select(GID=query, GENAME=Preferred_name) %>% na.omit()
gos <- emapper %>% dplyr::select(query, GOs) %>% na.omit()

gene2go <- data.frame(GID = character(),
                      GO = character(),
                      EVIDENCE = character())
for (row in 1:nrow(gos)) {
  the_gid <- gos[row,"query"][[1]]
  the_gos <- str_split(gos[row,"GOs"],",",simplify = FALSE)[[1]]
  df_temp <- data_frame(GID = rep(the_gid, length(the_gos)),
                        GO = the_gos,
                        EVIDENCE = rep("IEA", length(the_gos)))
  gene2go <- rbind(gene2go, df_temp)}

gene2go$GO[gene2go$GO=="-"] <- NA
gene2go <- na.omit(gene2go)

# step 3: extract KEGG from emapper
gene2ko <- emapper %>% dplyr::select(GID=query,Ko=KEGG_ko) %>% na.omit()
gene2ko$Ko <- gsub("ko:","",gene2ko$Ko)

# prepare kegg pathway
update_kegg <- function(json = "ko00001.json") {
  pathway2name <- tibble(Pathway = character(), Name = character())
  ko2pathway <- tibble(Ko = character(), Pathway = character())
  kegg <- fromJSON(json)
  for (a in seq_along(kegg[["children"]][["children"]])) {
    A <- kegg[["children"]][["name"]][[a]]
    for (b in seq_along(kegg[["children"]][["children"]][[a]][["children"]])) {
      B <- kegg[["children"]][["children"]][[a]][["name"]][[b]] 
      for (c in seq_along(kegg[["children"]][["children"]][[a]][["children"]][[b]][["children"]])) {
        pathway_info <- kegg[["children"]][["children"]][[a]][["children"]][[b]][["name"]][[c]]
        pathway_id <- str_match(pathway_info, "ko[0-9]{5}")[1]
        pathway_name <- str_replace(pathway_info, " \\[PATH:ko[0-9]{5}\\]", "") %>% str_replace("[0-9]{5} ", "")
        pathway2name <- rbind(pathway2name, tibble(Pathway = pathway_id, Name = pathway_name))
        kos_info <- kegg[["children"]][["children"]][[a]][["children"]][[b]][["children"]][[c]][["name"]]
        kos <- str_match(kos_info, "K[0-9]*")[,1]
        ko2pathway <- rbind(ko2pathway, tibble(Ko = kos, Pathway = rep(pathway_id, length(kos))))}}}
  save(pathway2name, ko2pathway, file = "kegg_info.RData")}

update_kegg()

load(file="kegg_info.RData")


gene2pathway <- gene2ko %>% left_join(ko2pathway, by="Ko") %>% 
  dplyr::select(GID,Pathway) %>% na.omit()

tax_id = "7004"
genus = "Locusta" 
species = "migratoria"

makeOrgPackage(gene_info=gene_info,
               go=gene2go,
               ko=gene2ko,
               maintainer = "Xinghua Li <920230688@qq.com>",
               author = "Xinghua Li <920230688@qq.com>",
               pathway=gene2pathway,
               version="0.0.1",
               outputDir = ".",
               tax_id=tax_id,
               genus=genus,
               species=species,
               goTable="go")




  
  
  
  
  
  
