library(ComplexHeatmap)
library(dplyr)
library(circlize)

col_text <- "grey40"


####################   prepare data ################################
gene <- read.csv("gene_density_1M.txt",header=F,sep="\t")%>%
  arrange(V1,V2);head(gene)
gc <- read.csv("Lmig_GC.txt",header=F,sep="\t") %>%
  arrange(V1,V2)
pi <- read.csv("Lmig_pi.txt",header=F,sep="\t") %>%
  arrange(V1,V2)
rho <- read.csv("Lmig_rho_2M_mean.txt",header=F,sep="\t") %>%
  arrange(V1,V2)
mv <- read.csv("maverick_2M-1.txt",header=F,sep="\t") %>%
  arrange(V1,V2)
dna <- read.csv("dna_dna_density-1.txt",header=F,sep="\t") %>%
  arrange(V1,V2)

######################  prepare chromosome  ###########################

chr<-read.csv("Lmig_chr_length.txt",
              header=F,sep="\t")
chr

############################ star circos #################################

circos.par("track.height"=0.8,gap.degree=c(rep(2,11),12),cell.padding=c(0,0,0,0))

circos.initialize(factors=chr$V1,
                  xlim=matrix(c(rep(0,12),chr$V2),ncol=2))

# plot track: gene density
color_gene <- colorRamp2(breaks = c(1, 4, 9), 
                         col = c('Ivory2', 'Ivory3','Ivory4'))

circos.genomicTrackPlotRegion(
  gene, track.height = 0.06, stack = TRUE,bg.border = F,
  panel.fun = function(region, value, ...) {
    circos.genomicRect(region, value, col = color_gene(value[[1]]), border = NA, ...)
  })
############## add chr label
circos.track(track.index = 1,ylim = c(0, 5), panel.fun = function(x, y) {
  circos.text(CELL_META$xcenter, CELL_META$ylim[2] + mm_y(5), 
              gsub(".*chr", "", CELL_META$sector.index), cex = 0.6, niceFacing = TRUE)
}, track.height = 5, bg.border = F)


# prepare scale

brk <- c(0,100,200,300,400,500,600,700,800,900,990)*1000000
brk_label<-paste0(c(0,100,200,300,400,500,600,700,800,900,990),"M")

# plot X-axis
circos.track(track.index = get.current.track.index(), 
             panel.fun = function(x, y) {
               circos.axis(h="top",
                           major.at=brk,
                           labels=brk_label,
                           labels.cex=0.4,
                           col=col_text,
                           labels.col=col_text,
                           lwd=0.7,
                           labels.facing="clockwise")
             },
             bg.border=F)


########################################################################
# plot line gc
gc <- filter(gc,V4>0.3,V4<0.7)
circos.trackPlotRegion(factors=gc$V1,ylim=c(0.3,0.7),track.heigh=0.15)
circos.trackLines(gc$V1,gc$V2,gc$V4,col="DeepSkyBlue")

##############################################################################
  # plot pi
  color_pi <- colorRamp2(breaks = c(0.2, 0.3, 0.4), 
                           col = c('#D2B48C', 'Chartreuse3', 'gold'))
  circos.genomicTrackPlotRegion(
    pi, track.height = 0.12, stack = TRUE, bg.border = NA,
    panel.fun = function(region, value, ...) {
      circos.genomicRect(region, value, col = color_pi(value[[1]]), border = NA, ...)
    } )
  
  # plot rho
  color_rho <- colorRamp2(breaks = c(100, 150, 180), 
                               col = c('#D2B48C', 'Chartreuse3', 'gold'))
  circos.genomicTrackPlotRegion(
    rho, track.height = 0.12, stack = TRUE, bg.border = NA,
    panel.fun = function(region, value, ...) {
      circos.genomicRect(region, value, col = color_rho(value[[1]]), border = NA, ...)
    } )
   # plot track: Maverick density
  color_mv <- colorRamp2(breaks = c(0, 40, 100), 
                         col = c('#D2B48C','Chartreuse3','gold'))
  
  circos.genomicTrackPlotRegion(
    mv, track.height = 0.12, stack = TRUE, bg.border = NA,
    panel.fun = function(region, value, ...) {
      circos.genomicRect(region, value, col = color_mv(value[[1]]), border = NA, ...)
    } ) 

#####################################################
#  add legend
###############################################################################
color_assign <- colorRamp2(breaks = c(0, 150, 300), 
                       col = c('#D2B48C', 'Chartreuse3', 'gold'))
gene_legend <- Legend(
  at = c(0, 150, 300), 
  labels = c("Lower", "Medium", "Higher"),
  labels_gp = gpar(fontsize = 6),
  col_fun = color_assign,
  title = ' ', 
  title_gp = gpar(fontsize = 7), 
  grid_height = unit(0.4, 'cm'), 
  grid_width = unit(0.4, 'cm'), 
  type = 'points', pch = NA, 
  background = c('#D2B48C', 'Chartreuse3', 'gold'))

pushViewport(viewport(x = 0.9, y = 0.1))
grid.draw(gene_legend)

upViewport()

circos.clear()
