#!/bin/bash
#SBATCH -J H03
#SBATCH -N 1
#SBATCH -p a01216amd
#SBATCH --cpus-per-task=20

cd $SLURM_SUBMIT_DIR
# bwa index -a bwtsw LM.hifiasm.fa

# H03

bwa mem -t 20 LM.hifiasm.fa Locustamigratoriamanilensismeyen_AB856-H03-1_good_1.fq.gz | samtools view -@ 20 -Sb - > LM_HiC_H03_1.bam
bwa mem -t 20 LM.hifiasm.fa Locustamigratoriamanilensismeyen_AB856-H03-1_good_2.fq.gz | samtools view -@ 20 -Sb - > LM_HiC_H03_2.bam

samtools view LM_HiC_H03_1.bam | perl filter_five_end.pl | samtools view -Sb - > LM_HiC_H03_FILT_1.bam
samtools view LM_HiC_H03_2.bam | perl filter_five_end.pl | samtools view -Sb - > LM_HiC_H03_FILT_2.bam

perl two_read_bam_combiner.pl LM_HiC_H03_FILT_1.bam LM_HiC_H03_FILT_2.bam samtools 10 | samtools view -bS -t LM.hifiasm.fa.fai - | samtools sort -@ 20 -o LM_HiC_H03.bam -

java -jar picard.jar AddOrReplaceReadGroups INPUT=LM_HiC_H03.bam OUTPUT=LM_HiC_H03_RG.bam ID=H03 LB=H03 SM=LM1 PL=ILLUMINA PU=none

java -jar picard.jar MarkDuplicates INPUT=LM_HiC_H03_RG.bam OUTPUT=LM_HiC_H03_final.bam METRICS_FILE=metrics.H03.txt  ASSUME_SORTED=TRUE VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=TRUE
