#!/bin/bash
#SBATCH -J H01
#SBATCH -N 1
#SBATCH -p a01216amd
#SBATCH --cpus-per-task=20

cd $SLURM_SUBMIT_DIR
# bwa index -a bwtsw LM.hifiasm.fa

# H01
bwa mem -t 20 LM.hifiasm.fa Locustamigratoriamanilensismeyen_AB856-H01-1_good_1.fq.gz | samtools view -@ 20 -Sb - > LM_HiC_H01_1.bam
bwa mem -t 20 LM.hifiasm.fa Locustamigratoriamanilensismeyen_AB856-H01-1_good_2.fq.gz | samtools view -@ 20 -Sb - > LM_HiC_H01_2.bam

samtools view LM_HiC_H01_1.bam | perl filter_five_end.pl | samtools view -Sb - > LM_HiC_H01_FILT_1.bam
samtools view LM_HiC_H01_2.bam | perl filter_five_end.pl | samtools view -Sb - > LM_HiC_H01_FILT_2.bam

perl two_read_bam_combiner.pl LM_HiC_H01_FILT_1.bam LM_HiC_H01_FILT_2.bam samtools 10 | samtools view -bS -t LM.hifiasm.fa.fai - | samtools sort -@ 20 -o LM_HiC_H01.bam -

java -jar picard.jar AddOrReplaceReadGroups INPUT=LM_HiC_H01.bam OUTPUT=LM_HiC_H01_RG.bam ID=H01 LB=H01 SM=LM1 PL=ILLUMINA PU=none

java -jar picard.jar MarkDuplicates INPUT=LM_HiC_H01_RG.bam OUTPUT=LM_HiC_H01_final.bam METRICS_FILE=metrics.H01.txt  ASSUME_SORTED=TRUE VALIDATION_STRINGENCY=LENIENT REMOVE_DUPLICATES=TRUE

