#!/bin/bash
#SBATCH -J merge
#SBATCH -N 1
#SBATCH -p a01216amd
#SBATCH --cpus-per-task=32

cd $SLURM_SUBMIT_DIR


## merge bam
java -jar picard.jar MergeSamFiles LM_HiC_H01_final.bam LM_HiC_H02_final.bam LM_HiC_H03_final.bam LM_HiC_H04_final.bam OUTPUT=LM_HiC_merged.bam USE_THREADING=TRUE ASSUME_SORTED=TRUE VALIDATION_STRINGENCY=LENIENT

samtools index LM_HiC_merged.bam

perl get_stats.pl LM_HiC_merged.bam > LM_HiC_merged.bam.stats


