/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Map;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceSchemeFactory;
import picard.vcf.GenotypeConcordanceStates;

public class GenotypeConcordanceContingencyMetrics
extends MetricBase {
    public VariantContext.Type VARIANT_TYPE;
    public String TRUTH_SAMPLE;
    public String CALL_SAMPLE;
    public long TP_COUNT;
    public long TN_COUNT;
    public long FP_COUNT;
    public long FN_COUNT;
    public long EMPTY_COUNT;

    public GenotypeConcordanceContingencyMetrics() {
    }

    public GenotypeConcordanceContingencyMetrics(VariantContext.Type variantType, GenotypeConcordanceCounts concordanceCounts, String truthSample, String callSample, boolean missingSitesFlag) {
        this.VARIANT_TYPE = variantType;
        this.TRUTH_SAMPLE = truthSample;
        this.CALL_SAMPLE = callSample;
        GenotypeConcordanceSchemeFactory schemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme scheme = schemeFactory.getScheme(missingSitesFlag);
        scheme.validateScheme();
        concordanceCounts.validateCountsAgainstScheme(scheme);
        Map<GenotypeConcordanceStates.ContingencyState, Long> counts = concordanceCounts.getContingencyStateCounts(scheme);
        this.TP_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.TP);
        this.TN_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.TN);
        this.FP_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.FP);
        this.FN_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.FN);
        this.EMPTY_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.EMPTY);
    }
}

