/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.util.Iterator;

public class ByIntervalListVariantContextIterator
implements Iterator<VariantContext> {
    private final VCFFileReader reader;
    private final Iterator<Interval> intervals;
    private CloseableIterator<VariantContext> currentCloseableIterator = null;
    private Iterator<VariantContext> currentIterator = null;
    private Interval lastInterval = null;

    public ByIntervalListVariantContextIterator(VCFFileReader reader, IntervalList intervals) {
        this.reader = reader;
        this.intervals = intervals.uniqued().iterator();
        this.advance();
    }

    private boolean overlapsInterval(VariantContext ctx, Interval interval) {
        if (!ctx.getContig().equals(interval.getContig())) {
            return false;
        }
        return CoordMath.overlaps(ctx.getStart(), ctx.getEnd(), interval.getStart(), interval.getEnd());
    }

    private void advance() {
        while ((this.currentIterator == null || !this.currentIterator.hasNext()) && this.intervals.hasNext()) {
            if (this.currentIterator != null) {
                this.currentCloseableIterator.close();
            }
            Interval interval = this.intervals.next();
            Interval previousInterval = this.lastInterval;
            this.currentCloseableIterator = this.reader.query(interval.getContig(), interval.getStart(), interval.getEnd());
            this.currentIterator = this.currentCloseableIterator.stream().filter(ctx -> null == previousInterval || !this.overlapsInterval((VariantContext)ctx, previousInterval)).iterator();
            this.lastInterval = interval;
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public VariantContext next() {
        VariantContext ctx = this.currentIterator.next();
        this.advance();
        return ctx;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

