/*
 * Decompiled with CFR 0.152.
 */
package picard.util.IntervalList;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public interface IntervalListScatterer {
    default public List<IntervalList> scatter(IntervalList inputList, int scatterCount) {
        if (scatterCount < 1) {
            throw new IllegalArgumentException("scatterCount < 1");
        }
        IntervalList processedIntervalList = this.preprocessIntervalList(inputList);
        long idealSplitWeight = this.deduceIdealSplitWeight(processedIntervalList, scatterCount);
        Log.getInstance(IntervalListScatterer.class).info("idealSplitWeight=" + idealSplitWeight);
        ArrayList<IntervalList> accumulatedIntervalLists = new ArrayList<IntervalList>();
        IntervalList runningIntervalList = new IntervalList(processedIntervalList.getHeader());
        ArrayDeque<Interval> intervalQueue = new ArrayDeque<Interval>(processedIntervalList.getIntervals());
        long weightRemaining = this.listWeight(processedIntervalList);
        while (!intervalQueue.isEmpty() && accumulatedIntervalLists.size() < scatterCount - 1) {
            double projectedSizeOfRemainingDivisions;
            long currentSize;
            Interval interval = intervalQueue.pollFirst();
            List<Interval> split = this.takeSome(interval, idealSplitWeight, currentSize = this.listWeight(runningIntervalList), projectedSizeOfRemainingDivisions = (double)(weightRemaining - this.listWeight(runningIntervalList)) / ((double)scatterCount - (double)accumulatedIntervalLists.size() - 1.0));
            if (split.size() != 2) {
                throw new IllegalStateException("takeSome should always return exactly 2 (possibly null) intervals.");
            }
            if (split.get(1) != null) {
                intervalQueue.addFirst(split.get(1));
            }
            if (split.get(0) == null) {
                weightRemaining -= this.listWeight(runningIntervalList);
                accumulatedIntervalLists.add(runningIntervalList);
                runningIntervalList = new IntervalList(processedIntervalList.getHeader());
                continue;
            }
            runningIntervalList.add(split.get(0));
        }
        runningIntervalList.addall(intervalQueue);
        if (!runningIntervalList.getIntervals().isEmpty()) {
            accumulatedIntervalLists.add(runningIntervalList);
        }
        return accumulatedIntervalLists;
    }

    default public IntervalList preprocessIntervalList(IntervalList inputList) {
        return inputList.sorted();
    }

    public long intervalWeight(Interval var1);

    public long listWeight(IntervalList var1);

    public List<Interval> takeSome(Interval var1, long var2, long var4, double var6);

    public int deduceIdealSplitWeight(IntervalList var1, int var2);
}

